/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.IO;
using System.Collections.Generic;
using Xamarin.Forms;

namespace FileManager
{
    /// <summary>
    /// This is class is defined for list view source data template.
    /// </summary>
    public class Data
    {
        public string Name { get; set; }
        public string Icon { get; set; }
        public bool IsFile { get; set; }
    }

    /// <summary>
    /// The interface which get all the directory information.
    /// </summary>
    public interface IInterface
    {
        /// <summary>
        /// Get all of the directories for specified path.
        /// </summary>
        /// <param name="path">The <see cref="string"> path which is the target path to get directories.</param>
        /// <returns>Directories to get.</returns>
        List<Data> GetDirectoriesForPath(string path);

        /// <summary>
        /// Get all of the files for specified path.
        /// </summary>
        /// <param name="path">The <see cref="string"> path which is the target path to get files.</param>
        /// <returns>Files to get.</returns>
        List<Data> GetFilesForPath(string path);

        /// <summary>
        /// Exit current application.
        /// </summary>
        void ExitApp();

        /// <summary>
        /// Get the local storage root path.
        /// </summary>
        /// <returns>Local storage root path.</returns>
        string GetLocalStorageRootPath();
    }
}
