﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.IO;
using FileManager.Tizen;

[assembly: Xamarin.Forms.Dependency(typeof(DirectoryInformationImplementation))]

namespace FileManager.Tizen
{
    /// <summary>
    /// The implementation of the <see cref="IDirectoryInformation"/> interface.
    /// </summary>
    class DirectoryInformationImplementation : IDirectoryInformation
    {
        /// <summary>
        /// Get all of the directory information for specified path.
        /// </summary>
        /// <param name="path">The <see cref="string"> path which is the target path to get directory information.</param>
        public List<string> GetDirectoriesForPath(string path)
        {
            if (!Directory.Exists(path))
            {
                return null;
            }

            // Create a list of directory name.
            List<string> dirNames = new List<string>();

            // Create DirectoryInfo class to get directory information.
            System.IO.DirectoryInfo dir = new System.IO.DirectoryInfo(path);
            foreach (System.IO.DirectoryInfo d in dir.GetDirectories())
            {
                dirNames.Add(d.Name);
            }

            return dirNames;
        }
    }
}

