/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


namespace EmailUI
{
    using System;
    using System.Collections.Generic;
    using Xamarin.Forms;

    /// <summary>
    /// The main page of the EmailUI application.
    /// </summary>
    public class EmailPage : MasterDetailPage
    {
        private MasterPageCS masterPage;
        private DetailPageCS detailPage;

        public EmailPage()
        {
            //Install the MasterPage
            this.masterPage = new MasterPageCS();
            this.Master = this.masterPage;
            this.masterPage.ListView.ItemSelected += this.MasterOnItemSelected;

            //Install the DetailPage
            this.detailPage = new DetailPageCS();
            this.Detail = this.detailPage;
            this.detailPage.ListView.ItemSelected += this.DetailOnItemSelected;

            // Title of this page
            this.Title = "In Box";

            // Create ToolbarItem and set the click callback
            Action toolbarClick = () =>
            {
                Navigation.PushModalAsync(new ComposePage());
            };
            ToolbarItems.Add(new ToolbarItem("+", null, toolbarClick, ToolbarItemOrder.Secondary, 0));
        }

        /// <summary>
        /// Called right after the Detail list item is selected.
        /// </summary>
        /// <param name="sender">the event sender</param>
        /// <param name="e">the event args</param>
        private void DetailOnItemSelected(object sender, SelectedItemChangedEventArgs e)
        {
            ((ListView)sender).SelectedItem = null;
            this.IsPresented = false;
        }

        /// <summary>
        /// Called right after the Master list item is selected.
        /// </summary>
        /// <param name="sender">the event sender</param>
        /// <param name="e">the event args</param>
        private void MasterOnItemSelected(object sender, SelectedItemChangedEventArgs e)
        {
            var item = e.SelectedItem as MasterPageItem;
            if (item.Name == "In Box")
            {
                Title = "In Box";
            }
            else
            {
                Title = "Out Box";
            }

            this.IsPresented = false;
        }
    }
}
