/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


namespace EmailUI
{
    using System;
    using System.Collections.Generic;
    using Xamarin.Forms;

    /// <summary>
    /// The compose page of the EmailUI application.
    /// </summary>
    public class ComposePage : ContentPage
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ComposePage"/> class.
        /// </summary>
        public ComposePage()
        {
            // The title of this page
            Title = "Compose";

            // Content view of this page.
            Content = new StackLayout
            {
                IsVisible = true,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,

                // Set the Orientations of the StackLayout, the layout is vertical
                Orientation = StackOrientation.Vertical,
                Children =
                {
                    // Add new Label
                    new Entry()
                    {
                        HeightRequest = 90,
                        Text = "example@tizen.com",
                        FontSize = 50
                    },
                    // Add new Label
                    new Entry()
                    {
                        HeightRequest = 90,
                        Placeholder = "To",
                        PlaceholderColor = Color.Gray,
                        FontSize = 50
                    },
                    // Add new Label
                    new Entry()
                    {
                        HeightRequest = 90,
                        Placeholder = "Subject",
                        PlaceholderColor = Color.Gray,
                        FontSize = 50
                    },
                    // Add new Label
                    new Entry()
                    {
                        HeightRequest = 90,
                        Placeholder = "Compose email",
                        PlaceholderColor = Color.Gray,
                        FontSize = 50
                    }
                }
            };
        }
    }
}
