"use strict";
/**
 * Basic enemy types
 */
var enemies = {
		/**
		 * Attributes of enemy: 
		 * x - initial position
		 * sprite - sprite of enemy
		 * A - constant horizontal velocity
		 * B - strength of horizontal sinusoidal velocity
		 * C - period of horizontal sinusoidal velocity
		 * D - time shift of horizontal sinusoidal velocity
		 * E - constant vertical velocity
		 * F - strength of vertical sinusoidal velocity
		 * G - period of vertical sinusoidal velocity
		 * H - 
		 * health - number of hits needed to kill the enemy
		 * damage - extent of damage to the PlayerShip object
		 * missiles - number of fired missiles
		 * firePercentage - percent of the missiles to be fired
		 * pointsHit - points added for hitting the enemy
		 * pointsDestroy - points added for destroying the enemy
		 */
	basic : {
		x : 100,
		sprite : 'enemy_purple',
		B : 100,
		C : 2,
		E : 100,
		health : 30,
		damage : 10,
		missiles : 2,
		firePercentage : 0.003,
		pointsHit : 15,
		pointsDestroy : 60
	},
	straight : {
		x : 100,
		sprite : 'enemy_ship',
		E : 200,
		health : 30,
		damage : 10,
		firePercentage : 0.001,
		pointsHit : 10,
		pointsDestroy : 40
	},
	slowing_down : {
		x : 100,
		sprite : 'enemy_ship',
		E : 300,
		F : 100,
		G : 5,
		health : 30,
		damage : 10,
		pointsHit : 5,
		pointsDestroy : 20
	},
	ltr : {
		x : 100,
		sprite : 'enemy_ship',
		B : 200,
		C : 2,
		E : 100,
		F : 50,
		G : 5,
		health : 30,
		damage : 10,
		missiles : 2,
		pointsHit : 15,
		pointsDestroy : 60
	},
	circle : {
		x : 400,
		sprite : 'enemy_circle',
		A : 0,
		B : -200,
		C : 1,
		E : 50,
		F : 200,
		G : 1,
		H : Math.PI / 2,
		health : 30,
		damage : 10,
		firePercentage : 0,
		pointsHit : 5,
		pointsDestroy : 20
	}, 
	bee : {
		x : 200,
		sprite : 'enemy_bee',
		B : 200,
		C : 0.8,
		E : 50,
		health : 20,
		damage : 10,
		firePercentage : 0.01,
		pointsHit : 5,
		pointsDestroy : 20
	}
};
var config = {
	fps : {
		nominal : 40,
		/**
		 * Minimal FPS threshold for good game performance.
		 * Under this threshold a message for user will be displayed.
		 */
		minThreshold : 20,
		/**
		 * In case FPS drops below this value starfield in the background is removed
		 * to upgrade performance
		 */
		removeBackgroundEffects: 30,
	},
	player : {
		bottomOffset : 200,
		topOffset : 50,
		leftOffset : 5,
		rightOffset : 5,
		/**
		 * Default zIndex of player on game board
		 */
		zIndex : 3
	},
	enemy : {
		topOffset : 50,
		/**
		 * Default zIndex of enemy on game board
		 */
		zIndex : 3
	},
	earth : {
		zIndex : 2
	},
	overheating : {
		/**
		 * Time to overheating the gun [in seconds]
		 */
		timeToOverheat : 15,
		/**
		 * Time to restoring efficiency of the gun  [in seconds]
		 */
		timeToRecovery : 8
	},
	powerUps : {
		/**
		 * sec
		 */
		dualPointsTime : 20,
		healPercantage : 5,
		repairPercentage : 20,
		/**
		 * sec
		 */
		shieldTime : 20
	},
	debug : false,
	resolution : {
		/**
		 * This is the game resolution to which the game will be scaled. If use = false then the game will be scaled to fit the screen If use = true then the game will be scaled for the given height and width will be calculated proportionally
		 */
		scaled : {
			use : false,
			height : 500
		}
	},
	angleOffset : 5,
	version : "1.0.3",
	allLevelsVisible : false,
	/**
	 * gyroscopeCalibration = true - if calibration is enabled, false - if default angles are set to 0,0,0
	 */
	gyroscopeCalibration : true,
	levels : [ {
		// FIRST LEVEL: one ship type, very slow
		period : 2400,
		types : [ {
			basicType : enemies.straight,
			overrides : {
				x : 650,
				E : 60,
				firePercentage : 0.008
			}
		} ],
		duration : 60,
		name : "We have contact!",
		powerUps : {
			number : 1
		}
	}, {
		// SECOND LEVEL: one ship type, faster
		period : 2300,
		types : [ {
			basicType : enemies.slowing_down,
			overrides : {
				x : 650,
				E : 60,
				firePercentage : 0.008
			}
		} ],
		duration : 90,
		name : "Ha, child's play",
		powerUps : {
			number : 2
		}
	}, {
		// THIRD LEVEL: one ship type, faster, more
		period : 2800,
		types : [ {
			basicType : enemies.straight,
			overrides : {
				x : 650,
				E : 65,
				firePercentage : 0.008
			}
		}, {
			basicType : enemies.slowing_down,
			overrides : {
				x : 650,
				E : 65,
				firePercentage : 0.008
			}
		} ],
		duration : 90,
		name : "Come and get me!",
		powerUps : {
			number : 3
		}
	}, {
		// FOURTH LEVEL: one ship type, dancing
		period : 1900,
		types : [ {
			basicType : enemies.basic,
			overrides : {
				x : 350,
				B : 200,
				C : 1,
				E : 55,
				firePercentage : 0.008
			}
		} ],
		duration : 120,
		name : "Tricky bastards...",
		powerUps : {
			number : 3
		}
	}, {
		// FIFTH LEVEL: two types
		period : 2700,
		types : [ {
			basicType : enemies.straight,
			overrides : {
				x : 650,
				E : 50,
				firePercentage : 0.006
			}
		}, {
			basicType : enemies.basic,
			overrides : {
				x : 350,
				B : 200,
				C : 1,
				E : 55,
				firePercentage : 0.008
			}
		} ],
		duration : 90,
		name : "Pff, I'm too good for this",
		powerUps : {
			number : 3
		}
	}, {
		// SIXTH LEVEL: one type, not firing
		period : 1000,
		types : [ {
			basicType : enemies.circle,
			overrides : {
				x : 300,
				B : 150,
				C : 1,
				E : 80
			}
		} ],
		duration : 60,
		name : "Faster...",
		powerUps : {
			number : 3
		}
	}, {
		// SEVENTH LEVEL: two types
		period : 2300,
		types : [ {
			basicType : enemies.straight,
			overrides : {
				x : 650,
				E : 45
			}
		}, {
			basicType : enemies.basic,
			overrides : {
				x : 400,
				B : 100,
				C : 1,
				E : 60
			}
		} ],
		duration : 90,
		name : "Tighter...",
		powerUps : {
			number : 3
		}
	}, {
		// EIGHTH LEVEL:
		period : 1400,
		types : [ {
			basicType : enemies.ltr,
			overrides : {
				x : 400,
				B : 300,
				E : 70, 
				firePercentage : 0.002
			}
		} ],
		duration : 60,
		name : "Maaan, them drunk or what???",
		powerUps : {
			number : 4
		}
	}, {
		// 9
		period : 1800,
		types : [ {
			basicType : enemies.straight,
			overrides : {
				x : 650,
				E : 40,
				firePercentage : 0.009
			}
		}, {
			basicType : enemies.circle,
			overrides : {
				x : 300,
				B : 100,
				C : 1,
				E : 20
			}
		} ],
		duration : 90,
		name : "Bastards!",
		powerUps : {
			number : 4
		}
	}, {
		// 10
		period : 3000,
		types : [ {
			basicType : enemies.straight,
			overrides : {
				x : 650,
				E : 150,
				firePercentage : 0.008
			}
		}, {
			basicType : enemies.slowing_down,
			overrides : {
				x : 400,
				E : 50,
				firePercentage : 0.006
			}
		}, {
			basicType : enemies.circle,
			overrides : {
				x : 300,
				B : 200,
				C : 2,
				E : 20
			}
		} ],
		duration : 90,
		name : "Seriously???",
		powerUps : {
			number : 4
		}
	}, {
		// 11
		period : 2300,
		types : [ {
			basicType : enemies.straight,
			overrides : {
				x : 650,
				E : 50,
				firePercentage : 0.008
			}
		}, {
			basicType : enemies.basic,
			overrides : {
				x : 400,
				B : 100,
				C : 1,
				E : 40
			}
		}, {
			basicType : enemies.circle,
			overrides : {
				x : 300,
				B : 100,
				C : 1,
				E : 20
			}
		} ],
		duration : 60,
		name : "Huh,...",
		powerUps : {
			number : 4
		}
	}, {
		// 12
		period : 1200,
		types : [ {
			basicType : enemies.bee
		} ],
		duration : 70,
		name : "Move soldier!",
		powerUps : {
			number : 4
		}
	}, {
		// LEVEL 13
		period : 1600,
		types : [ {
			basicType : enemies.bee,
			overrides : {
				x : 250,
				B : 100,
				E : 80
			}
		}, {
			basicType : enemies.straight,
			overrides : {
				x : 650,
				E : 120
			}
		}],
		duration : 100,
		name : "Too many...",
		powerUps : {
			number : 6
		}
	}, {
		// LEVEL 14
		period : 2400,
		types : [ {
			basicType : enemies.bee,
			overrides : {
				x : 450,
				B : 100,
				E : 60,
				firePercentage : 0.005
			}
		}, {
			basicType : enemies.slowing_down,
			overrides : {
				E : 120
			}
		}, {
			basicType : enemies.ltr,
			overrides : {
				x : 200,
				E : 65, 
				firePercentage : 0.002 
			}
		}],
		duration : 90,
		name : "I'm not your daddy",
		powerUps : {
			number : 6
		}
	}, {
		// LEVEL 15
		period : 2400,
		types : [ {
			basicType : enemies.bee,
			overrides : {
				E : 80,
				firePercentage : 0.004
			}
		}, {
			basicType : enemies.bee,
			overrides : {
				x : 450,
				B : 100,
				E : 40,
				firePercentage : 0.004
			}
		}, {
			basicType : enemies.basic,
			overrides : {
				x : 250,
				C : 1,
				E : 110,
				firePercentage : 0.006
			}
		} ],
		duration : 90,
		name : "Hit! hit! hit!",
		powerUps : {
			number : 7
		}
	}, {
		// LEVEL 16
		period : 3300,
		types : [ {
			basicType : enemies.slowing_down,
			overrides : {
				E : 80,
				firePercentage : 0.004
			}
		}, {
			basicType : enemies.ltr,
			overrides : {
				x : 450,
				B : 100,
				E : 40,
				firePercentage : 0.004
			}
		}, {
			basicType : enemies.basic,
			overrides : {
				x : 250,
				C : 1,
				E : 90,
				firePercentage : 0.006
			}
		} ],
		duration : 70,
		name : "Smash them all!",
		powerUps : {
			number : 7
		}
	}, {
		// 17
		// ELEVENTH LEVEL: many ships.. 15
		period : 3500,
		types : [ {
			basicType : enemies.straight,
			overrides : {
				x : 650,
				E : 40
			}
		}, {
			basicType : enemies.basic,
			overrides : {
				x : 400,
				B : 100,
				C : 1,
				E : 40
			}
		}, {
			basicType : enemies.ltr,
			overrides : {
				x : 100,
				E : 40,
			}
		}, {
			basicType : enemies.circle,
			overrides : {
				x : 300,
				B : 100,
				C : 1,
				E : 20
			}
		} ],
		duration : 60,
		name : "AARRRRGGHH, FIRE!!!",
		powerUps : {
			number : 6
		}
	}, {
		// LEVEL 18
		period : 2400,
		types : [ {
			basicType : enemies.ltr,
			overrides : {
				E : 80,
				firePercentage : 0.004
			}
		}, {
			basicType : enemies.circle,
			overrides : {
				x : 600, 
				B : 100
			}
		}, {
			basicType : enemies.bee,
			overrides : {
				x : 450,
				B : 100,
				E : 40,
				firePercentage : 0.004
			}
		}, {
			basicType : enemies.basic,
			overrides : {
				x : 250,
				C : 1,
				E : 110,
				firePercentage : 0.006
			}
		} ],
		duration : 70,
		name : "More?",
		powerUps : {
			number : 6
		}
	}, {
		// LEVEL 19
		period : 3000,
		types : [ {
			basicType : enemies.slowing_down,
			overrides : {
				x : 650,
				E : 100,
				firePercentage : 0.008
			}
		}, {
			basicType : enemies.basic,
			overrides : {
				x : 350,
				B : 200,
				C : 2,
				E : 60,
				firePercentage : 0.008
			}
		}, {
			basicType : enemies.circle,
			overrides : {
				x : 300,
				B : 150,
				C : 1,
				E : 80
			}
		} ],
		duration : 80,
		name : "Faster...",
		powerUps : {
			number : 4
		}
	}, {// 20
		// TWELFTH LEVEL: last
		period : 4000,
		types : [ {
			basicType : enemies.straight,
			overrides : {
				x : 650,
				E : 40
			}
		}, {
			basicType : enemies.basic,
			overrides : {
				x : 300,
				B : 100,
				C : 1,
				E : 20
			}
		}, {
			basicType : enemies.ltr,
			overrides : {
				x : 400, 
				E : 60,
			}
		}, {
			basicType : enemies.slowing_down,
			overrides : {
				x : 650,
				E : 50,
			}
		}, {
			basicType : enemies.circle,
			overrides : {
				x : 300,
				B : 100,
				C : 1,
				E : 30
			}
		} ],
		duration : 100,
		name : "FINAL ENCOUNTER!!!",
		powerUps : {
			number : 7
		}
	} ]
};
