"use strict";
var Hud = function(x, y) {
	var level = 1;
	var earthLife = 100;
	var playerLife = 100;
	this.type = game.getObjectTypes().HUD;
	this.setup('hud');
	this.x = x;
	this.y = y;
	this.healthWidth = 155;

	this.barColor = function(life) {
		var color;
		if (life <= 75) {
			if (life <= 50) {
				if (life <= 25)
					color = "#A30A0A";
				else
					color = "#CA9100";
			} else
				color = "#CAC200";
		} else
			color = "#75B400";
		return color;
	};

	this.drawOver = function(ctx) {
		ctx.fillStyle = "#FFDD4A";
		ctx.textAlign = "center";
		ctx.font = "20px bangers";
		if (level)
			ctx.fillText(level, 105, 40, 30);
		ctx.font = "34px bangers";
		ctx.fillText(game.points, 620, 38, 200);
	};

	this.drawUnder = function(ctx) {
		// black background box
		ctx.fillStyle = '#000000';
		ctx.fillRect(0, 0, 710, 43);
		
		
		// player
		ctx.fillStyle = this.barColor(playerLife);
		ctx.fillRect(170, 3, playerLife / 100 * this.healthWidth, 38);

		// earth
		 ctx.fillStyle = this.barColor(earthLife);
		 ctx.fillRect(370, 3, earthLife / 100 * this.healthWidth, 38);
	};

	/**
	 * Sets level
	 * 
	 * @param {Object|Level} pLevel
	 */
	this.setLevel = function(pLevel) {
		game.log(pLevel);
		level = pLevel.num;
	};

	/**
	 * Sets PlayerLife
	 * 
	 * @param {Number} pLife
	 */
	this.setPlayerLife = function(pLife) {
		playerLife = pLife;
	};

	/**
	 * Sets Earth health
	 * 
	 * @param {Number} eLife
	 */
	this.setEarthLife = function(eLife) {
		earthLife = eLife;
	};
};

game.inherit(Hud, Sprite);