"use strict";
var view = (function() {
	/**
	 * These values are set in index.html by canvas tag.
	 */
	var width;
	var height;
	/**
	 * These are the scaled values
	 */
	var sWidth;
	var sHeight;
	var scale;
	var fontSize = 25;
	var sFontSize;

	return {

		/**
		 * Gets current scale
		 * 
		 * @returns {Number} scale
		 */
		getScale : function() {
			return (scale) ? scale : 1;
		},
		getScaledWidth : function() {
			return sWidth;
		},
		getScaledHeight : function() {
			return sHeight;
		},
		getWidth : function() {
			return width;
		},
		getHeight : function() {
			return height;
		},
		/**
		 * Function responsible for scaling canvas to screen size
		 * 
		 */
		resize : function() {
			if (config.resolution.scaled.use) {
				var scaleWidth = width;
				var scaleHeight = config.resolution.scaled.height;
			} else {
				var scaleWidth = $(window).width();
				var scaleHeight = $(window).height();
			}
			scale = scaleHeight / height;
			var newWidth = Math.floor(scale * width);
			$("#game").attr("height", scaleHeight).attr("width", newWidth);
			if (game.getCtx())
				game.getCtx().scale(scale, scale);
			$("#container").height(scaleHeight).width(newWidth);
			sWidth = newWidth;
			sHeight = scaleHeight;
			// Scale main font size.
			sFontSize = Math.round(fontSize * scale);
			$(document.body).css('fontSize', sFontSize + 'px');
		},

		/**
		 * Power state change according to Tizen 2.0.0 Device API
		 * 
		 * @param type
		 * @returns
		 */
		setPowerState : function(type) {
			game.log('setPowerState' + type);
			if (this.isItTizen())
				try {
					tizen.power.request("SCREEN", type);
				} catch (e) {
					game.log("ERROR: Unable to set power state");
				}
//			else if (this.isItAndroidWebView()) {
//				Android.setScreenOn((type === "SCREEN_BRIGHT") ? true : false);
//			}
		},

		/**
		 * Checks if the web runtime is appropriate for the game
		 * 
		 * @returns {Boolean}
		 */
		checkEnviroment : function() {
			game.log("checkEnviroment");
			var canvas = document.getElementById('game');
			var ctx = canvas.getContext && canvas.getContext('2d');
			width = canvas.width;
			height = canvas.height;
			if (!Modernizr.canvas || !Modernizr.localstorage) {
				this.resize();
				this.error("Earth Guard cannot be launched on this device/browser!");
				return false;
			}
			game.setContext(canvas, ctx);
			$("#container").height(height).width(width);

			if (!this.isItMobile()) {
				$('head').append('<link rel="stylesheet" href="./css/menu.desktop.css" type="text/css" />');
			}
			return true;
		},

		/**
		 * Checks if application is launched on Tizen
		 * 
		 * @returns {Boolean} true if in Tizen
		 */
		isItTizen : function() {
			return /Tizen/.test(navigator.userAgent);
		},

		/**
		 * Checks if application is launched on Tizen device or in Android web view
		 * 
		 * @returns {Boolean} true if Tizen
		 */
		isItMobile : function() {
			if (this.isItTizen()) {
				return true;
			} else
				return false;
		},
		/**
		 * Display fallback screen.
		 * 
		 * @param {String} message Error message to display.
		 */
		error : function error(message) {
			var $fallback = $('<div class="fallback-screen"><img class="logo" src="./images/fallback_screen_logo.png" /><p class="message">' + message + '</p><img class="image" src="./images/fallback_screen_img.png" /></div>');

			$('#container').append($fallback);

			var onClickHandler = function(event) {
				event.stopPropagation();

				return false;
			};

			$fallback.on({
				click : onClickHandler
			});
		}
	};
}());