"use strict";
var spriteSheet = function() {
	var sprites = {
		ship : {
			sx : 0,
			sy : 2113,
			w : 51,
			h : 53,
			frames : 0
		},
		missile : {
			sx : 14,
			sy : 42,
			w : 4,
			h : 10,
			frames : 1
		},
		enemy_missile : {
			sx : 7,
			sy : 42,
			w : 7,
			h : 20,
			frames : 1
		},
		enemy_purple : {
			sx : 37,
			sy : 0,
			w : 42,
			h : 43,
			frames : 1
		},
		enemy_bee : {
			sx : 79,
			sy : 0,
			w : 37,
			h : 43,
			frames : 1
		},
		enemy_ship : {
			sx : 116,
			sy : 0,
			w : 42,
			h : 43,
			frames : 1
		},
		enemy_circle : {
			sx : 158,
			sy : 0,
			w : 32,
			h : 33,
			frames : 1
		},
		explosion : {
			sx : 2,
			sy : 71,
			w : 63,
			h : 50,
			frames : 12
		},
		explosion_yellow_small : {
			sx : 2,
			sy : 1826,
			w : 21,
			h : 17,
			frames : 12
		},
		explosion_green : {
			sx : 2,
			sy : 1843,
			w : 63,
			h : 50,
			frames : 12
		},
		earth : {
			sx : 0,
			sy : 126,
			w : 720,
			h : 166,
			frames : 1
		},
		earth_2 : {
			sx : 0,
			sy : 294,
			w : 720,
			h : 166,
			frames : 1
		},
		earth_3 : {
			sx : 0,
			sy : 460,
			w : 720,
			h : 166,
			frames : 1
		},
		earth_4 : {
			sx : 0,
			sy : 626,
			w : 720,
			h : 166,
			frames : 1
		},
		main_logo : {
			sx : 0,
			sy : 795,
			w : 505,
			h : 435,
			frames : 1
		},
		main_space_ship : {
			sx : 0,
			sy : 1226,
			w : 720,
			h : 600,
			frames : 1
		},
		hud : {
			sx : 191,
			sy : 0,
			w : 710,
			h : 45,
			frames : 1
		},
		star : {
			sx : 245,
			sy : 1826,
			w : 11,
			h : 11,
			frames : 1
		},
		powerUp_double : {
			sx : 0,
			sy : 1893,
			w : 44,
			h : 44,
			frames : 1
		},
		powerUp_repair : {
			sx : 0,
			sy : 1937,
			w : 44,
			h : 44,
			frames : 1
		},
		powerUp_heal : {
			sx : 0,
			sy : 1981,
			w : 44,
			h : 44,
			frames : 1
		},
		powerUp_shield : {
			sx : 0,
			sy : 2025,
			w : 44,
			h : 44,
			frames : 1
		},
		powerUp_bomb : {
			sx : 0,
			sy : 2069,
			w : 44,
			h : 44,
			frames : 1
		},
		overheat : {
			sx : 0,
			sy : 2166,
			w : 22,
			h : 397,
			frames : 1
		}
	};
	var spriteSource = 'images/sprites.png';
	var image = new Image();

	return {
		load : function(callback) {
			image.onload = callback;
			image.src = spriteSource;
		},

		draw : function(ctx, sprite, x, y, frame) {
			var s = sprites[sprite];
			if (!frame)
				frame = 0;
			ctx.drawImage(image, s.sx + frame * s.w, s.sy, s.w, s.h, Math.floor(x), Math.floor(y), s.w, s.h);
		},
		getSprites : function() {
			return sprites;
		}
	};
}();