"use strict";
var PowerUp = function(x, y, type, period) {
	this.type = game.getObjectTypes().POWER_UP;
	this.typeOfPowerUp = type;
	this.setup(type, {
		frame : 0
	});
	this.x = x;
	this.y = y;
	this.subFrame = 0;
	this.period = period;
	this.step = function(dt) {
		this.frame = Math.floor(this.subFrame++ / this.period);
		if (this.frame === 21) {
			this.board.remove(this);
		}

		var collision = this.board.collide(this, game.getObjectTypes().PLAYER);
		if (collision) {
			this.hit();
		}
	};

	this.hit = function() {
		game.log(this.typeOfPowerUp);
		switch (this.typeOfPowerUp) {
		case 'powerUp_double':
			powerUpsHandler.doublePoints();
			break;
		case 'powerUp_repair':
			powerUpsHandler.repairPlayer();
			break;
		case 'powerUp_heal':
			powerUpsHandler.healEarth();
			break;
		case 'powerUp_bomb':
			powerUpsHandler.killAllEnemies();
			break;
		case 'powerUp_shield':
			powerUpsHandler.shield();
			break;
		default:
			break;
		}
		this.board.remove(this);
	}
};

game.inherit(PowerUp, Sprite);
