(function($) {
	// Checkbox.
	jQuery.widget('earthguard.checkbox', {
		options: {},
		_create: function() {
			// Hide checkbox.
			this.element.addClass('hidden');
			// Add widget.
			this.widget = $('<div class="checkbox" tabindex="1"/>').insertAfter(this.element);
		},
		_init: function() {
			var self = this;
			
			var onChangeEvent = function onChangeEvent () {
				self._refresh();
			};
			
			var onClickEvent = function onClickEvent () {
				self.element.prop('checked', !self.element.is(':checked')).change();
				self._refresh();
				return false;
			};
			
			var onKeyDownEvent = function onKeyDownEvent (event) {
				if (event.keyCode == 32) { // Spacebar.
					event.stopPropagation();
					return false;
				}
				return true;
			};
			
			var onKeyUpEvent = function onKeyUpEvent (event) {
				if (event.keyCode == 32) { // Spacebar.
					event.stopPropagation();
					self.widget.click();
					return false;
				}
				return true;
			};
			
			// Bind events to checkbox.
			this.element.bind({
				change: onChangeEvent
			});
			
			// Bind events to widget.
			this.widget.bind({
				click: onClickEvent,
				keydown: onKeyDownEvent,
				keyup: onKeyUpEvent
			});

			this._refresh();
		},
		_refresh: function() {
			// Add/remove 'checkboc-checked' class depending on checkbox state.
			var funcName = this.element.is(':checked') ? 'addClass' : 'removeClass';
			this.widget[funcName]('checkbox-checked');
		},
		destroy: function() {}
	});
	// Buttonset.
	jQuery.widget('earthguard.buttonset', {
		options: {},
		_create: function() {
			var self = this;
			
			// Find all radio buttons inside the section.
			this.element.addClass('hidden');
			// Add widget.
			this.widget = $('<div class="buttonset"/>').insertAfter(this.element);
			// Loop through options and generate button for each.
			var optionsIterator = function optionsIterator (undefined, option) {
				$('<div class="buttonset-button" tabindex="1" />')
					.attr({'data-value' : $(option).val()})
					.text($(option).html())
					.appendTo(self.widget);
			};
			$.each(this.element.children('option'), optionsIterator);
		},
		_init: function() {
			var self = this;
			
			var onChangeEvent = function onChangeEvent () {
				self._refresh();
			};
			
			// OnClick handler for buttons of button set.
			var onClickEvent = function onClickEvent (event) {
				// Clicking on element 
				self.element.val($(this).attr('data-value')).change();
				self._refresh();
				return false;
			};
			
			var onKeyDownEvent = function onKeyDownEvent (event) {
				if (event.keyCode == 32) { // Spacebar.
					event.stopPropagation();
					return false;
				}
				return true;
			};
			
			var onKeyUpEvent = function onKeyUpEvent (event) {
				if (event.keyCode == 32) { // Spacebar.
					event.stopPropagation();
					$(this).trigger('click');
					return false;
				}
				return true;
			};
			
			// Bind events to checkbox.
			this.element.bind({
				change: onChangeEvent
			});
			
			// Bind events to widget's buttons.
			this.widget.children('.buttonset-button').each(function () {
				$(this).bind({
					click: onClickEvent,
					keydown: onKeyDownEvent,
					keyup: onKeyUpEvent
				});
			});

			this._refresh();
		},
		_refresh: function() {
			this.widget.children('.buttonset-button') // Find all buttons in button set.
				.removeClass('selected') // First remove 'selected' class from all buttons.
				.filter('[data-value="'+ this.element.val() +'"]') // Narrow collection only to one element to select.
				.addClass('selected'); // Add 'selected' class to highlight button.
		},
		destroy: function() {}
	});
})(jQuery);