"use strict";
var EnemyMissile = function(x, y) {
	this.type = game.getObjectTypes().ENEMY_MISSILE;
	this.setup('enemy_missile', {damage: 2});
	this.x = x - this.w / 2;
	// Use the passed in y as the bottom of the missile
	this.y = y - this.h;
	// y velocity of Enemy Missile
	this.vy = 700; 
	
	/**
	 * Function checks if the EnemyMissile collides with Earth or Player, change the y position of the missile
	 * @param dt 
	 */
	this.step = function(dt) {
		this.y += this.vy * dt;
		
		var collision = this.board.collide(this, game.getObjectTypes().EARTH);
		if (collision) {
			this.hit(null, "explosion_green");
			collision.hit(this.damage);
		}
		
		collision = this.board.collide(this, game.getObjectTypes().PLAYER);
		if (collision) {
			this.hit();
			collision.hit(this.damage);
		}
	};
	
	/**
	 * Function defines how collision with other object affects the EnemyMissile (it destroys the missile and removes it from board)
	 */
	this.hit = function(damage, explosionName) {
		if (explosionName) {
			this.board.add(new Explosion(this.x + this.w/2, this.y + this.h, explosionName), 100);
		} else {
			this.board.add(new Explosion(this.x + this.w/2, this.y + this.h), 100);
		}
		this.board.remove(this);
	}
};

game.inherit(EnemyMissile, Sprite);