"use strict";
var Enemy = function(blueprint, override) {
	this.type = game.getObjectTypes().ENEMY;
	
	// Base parameters for every Enemy
	var baseParameters = {
		A : 0,
		B : 0,
		C : 0,
		D : 0,
		E : 0,
		F : 0,
		G : 0,
		H : 0,
		t : 0,
		// prevent before firing missile in every step
		firePercentage : 0.01,
		// time of reload the missile
		reloadTime : 0.75, 
		reload : 0,
		y: config.enemy.topOffset
	};
	this.merge(baseParameters);
	this.setup(blueprint.sprite, blueprint);
	this.merge(override);
	
	this.x = this.x * Math.random();

	/**
	 * Function changes the position and velocity of Enemy, fires missile 
	 * @param dt 
	 */
	this.step = function(dt) {
		this.t += dt;

		this.vx = this.A + this.B * Math.sin(this.C * this.t + this.D);
		this.vy = this.E + this.F * Math.sin(this.G * this.t + this.H);

		this.x += this.vx * dt;
		this.y += this.vy * dt;

		
		if (this.reload <= 0 && Math.random() < this.firePercentage) {
			this.reload = this.reloadTime;
			if (this.missiles == 2){
				this.board.add(new EnemyMissile(this.x, this.y + this.h), 100);
				this.board.add(new EnemyMissile(this.x + this.w, this.y + this.h), 100);
			} else {
				this.board.add(new EnemyMissile(this.x + this.w / 2, this.y + this.h), 100);
			}
		}
		this.reload -= dt;
	};
	
	/**
	 * Function defines how collision with other object affects the Enemy
	 * @param damage {Number} defines stage of destruction 
	 */
	this.hit = function(damage, explosionName) {
		this.health -= damage;
		if(this.health<=0) {
			// in this case the collision was with the Earth
			if (explosionName) {
				this.board.add(new Explosion(this.x + this.w/2, this.y + this.h/2, explosionName), 100);
			// in this case collision was with the enemy missile
			} else {
				game.points += (this.pointsDestroy || 40)  * powerUpsHandler.points;;
				this.board.add(new Explosion(this.x + this.w/2, this.y + this.h/2), 100);
			}
			this.board.remove(this);
		} else {
			game.points += (this.pointsHit || 10) * powerUpsHandler.points;
		} 
	};
};

game.inherit(Enemy, Sprite);
