"use strict";
var messageBoxManager = function() {
	var board;
	var lastMsgBox;
	var msgPtr;
	return {
		setBoard : function(mboard) {
			if (board && lastMsgBox)
				board.remove(lastMsgBox);
			board = mboard;
			clearTimeout(msgPtr);
		},

		show : function(messageBox, timeout) {
			clearTimeout(msgPtr);
			if (board && lastMsgBox)
				board.remove(lastMsgBox);
			lastMsgBox = messageBox;
			if (board && lastMsgBox)
				board.add(lastMsgBox, 5);

			msgPtr = setTimeout(function() {
				if (board && lastMsgBox)
					board.remove(lastMsgBox);
			}, (timeout) ? timeout : 5000);
		}
	}

}();