"use strict";
var PlayerShip = function(hud, overheat) {
	this.type = game.getObjectTypes().PLAYER;
	this.setup('ship');
	this.x = view.getWidth() / 2 - this.w / 2;
	this.y = view.getHeight() - this.h - config.player.bottomOffset;
	this.vx = 0;
	this.vy = 0;
	this.reloadTime = 0.25; // Quarter second reload
	this.reload = this.reloadTime;
	this.maxVel = 400;
	this.maxHealth = this.health = 130;
	this.hud = hud;
	var hasShield = false;
	this.hud.setPlayerLife(this.health / this.maxHealth * 100);
	this.overheat = overheat;

	/**
	 * Function sets velocity of the PlayerShip, changes its position, adds missile and checks if it collides with Enemy
	 * 
	 * @param dt
	 */
	this.step = function(dt) {
		if (hasShield)
			this.frame = 0;
		else
			this.frame = 1;

		this.vx = 0;
		this.vy = 0;

		// for angle lower than 30deg use this function 3*MAX*(angle/90)
		// for angle higher than 30deg use MAX
		if (game.keys['left']) {
			if (game.inputHandler.getDirection().left <= 0.3)
				this.vx = -this.maxVel * 3 * game.inputHandler.getDirection().left;
			else
				this.vx = -this.maxVel;
		}
		if (game.keys['right']) {
			if (game.inputHandler.getDirection().right <= 0.3)
				this.vx = this.maxVel * 3 * game.inputHandler.getDirection().right;
			else
				this.vx = this.maxVel;
		}
		if (game.keys['up']) {
			if (game.inputHandler.getDirection().up <= 0.3)
				this.vy = -this.maxVel * 3 * game.inputHandler.getDirection().up;
			else
				this.vy = -this.maxVel;
		}
		if (game.keys['down']) {
			if (game.inputHandler.getDirection().down <= 0.3)
				this.vy = this.maxVel * 3 * game.inputHandler.getDirection().down;
			else
				this.vy = this.maxVel;
		}

		this.x += this.vx * dt;
		this.y += this.vy * dt;

		if (this.x < 0 + config.player.leftOffset) {
			this.x = 0 + config.player.leftOffset;
		} else if (this.x > (view.getWidth() - this.w - config.player.rightOffset)) {
			this.x = view.getWidth() - this.w - config.player.rightOffset;
		}

		if (this.y < config.player.topOffset) {
			this.y = config.player.topOffset;
		} else if (this.y > (view.getHeight() - this.h - config.player.bottomOffset)) {
			this.y = view.getHeight() - this.h - config.player.bottomOffset;
		}

		this.reload -= dt;
		if (game.keys['fire'] && this.reload < 0 && !(this.overheat.blockFire)) {
			var a = 1 + Math.floor(this.overheat.overheatStage / 10);
			this.reload = a * this.reloadTime;

			this.board.add(new PlayerMissile(this.x + 5, this.y + this.h / 2), 50);
			this.board.add(new PlayerMissile(this.x + this.w - 5, this.y + this.h / 2), 50);
		}

		this.vx = 0;
		this.vy = 0;

		var collision = this.board.collide(this, game.getObjectTypes().ENEMY);
		if (collision) {
			this.hit(collision.damage);
			// Collision with player destroys the enemy
			collision.hit(collision.health);
		}
	};

	/**
	 * Function defines how collision with other object affects the PlayerShip
	 * 
	 * @param damage {Number} defines stage of destruction
	 */
	this.hit = function(damage, explosionName) {
		if (hasShield) {
			return false;
		}

		if (damage)
			this.health -= damage;
		if (this.health <= 0) {
			this.board.remove(this);
			if (explosionName) {
				this.board.add(new Explosion(this.x + this.w / 2, this.y + this.h / 2, explosionName), 75);
			} else {
				this.board.add(new Explosion(this.x + this.w / 2, this.y + this.h / 2), 75);
			}
		}
		this.hud.setPlayerLife(this.health / this.maxHealth * 100);
	};

	this.repair = function() {
		var repair = this.maxHealth * config.powerUps.repairPercentage / 100;
		var updatedHealth = this.health + repair;

		if (updatedHealth > this.maxHealth) {
			this.health = this.maxHealth;
		} else {
			this.health = updatedHealth;
		}
		game.log(this.health);
		this.hud.setPlayerLife(this.health / this.maxHealth * 100);
	}

	this.setShield = function(shield) {
		hasShield = shield;
	};

	this.hasShield = function() {
		return hasShield;
	};
};

game.inherit(PlayerShip, Sprite);
