window.onload = function() {

    // The dot data 
    var dotData = [{
        "x": 20,
        "y": 20,
        "rx": 3,
        "ry": 3,
        "width": 15,
        "height": 15,
        "color": "crimson",
        "description": "Low standings :("
    }, {
        "x": 22,
        "y": 40,
        "rx": 3,
        "ry": 3,
        "width": 15,
        "height": 15,
        "color": "green",
        "description": "Better standings :|"
    }, {
        "x": 42,
        "y": 52,
        "rx": 3,
        "ry": 3,
        "width": 15,
        "height": 15,
        "color": "red",
        "description": "Nice standings ;)"
    }, {
        "x": 60,
        "y": 60,
        "rx": 3,
        "ry": 3,
        "width": 15,
        "height": 15,
        "color": "orange",
        "description": "Great standings :D"
    }, {
        "x": 90,
        "y": 90,
        "rx": 3,
        "ry": 3,
        "width": 15,
        "height": 15,
        "color": "teal",
        "description": "SUPERB standings!"
    }];

    // Base size of our D3 chart in pixels
    var base_width = 250;
    var base_height = 500;

    // Set the margins of the chart
    var margin = {
        top: 25,
        right: 25,
        bottom: 100,
        left: 70
    };

    // Here we are creating the SVG instance
    var svg = d3.select("body").append("svg")
        .attr("width", base_width + margin.left + margin.right)
        .attr("height", base_height + margin.top + margin.bottom)
        .append("g")
        .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

    // Set the scales    
    var x_axis = d3.scaleLinear().domain(0, 100).range([0, base_width]); // switch place of the values both in domain and range to switch the axis direction
    var y_axis = d3.scaleLinear().domain(100, 0).range([base_height, 0]);

    // Scale the range of the data

    // Use this scaling if you want to only cover the extent of the data values

    /* x_axis.domain(d3.extent(dotData, function(d) { return d.x; }));  
		  y_axis.domain(d3.extent(dotData, function(d) { return d.y; })); */

    // Use this scaling if you want to cover the the data values from the beggining of the axes  

    x_axis.domain([0, d3.max(dotData, function(d) {
        return d.x;
    })]);
    y_axis.domain([0, d3.max(dotData, function(d) {
        return d.y;
    })]);

    // Assign the scaling to the window object so it can be used later as a global variablewhen we will be specyfing the point postions	

    window.x_axis = x_axis;
    window.y_axis = y_axis;

    // Add an SVG text element for every point 
    var pointLabels = svg.selectAll("text")
        .data(dotData)
        .enter()
        .append("text");

    // Specify attributes for the point coordinate labels
    var textLabels = pointLabels
        .attr("x", function(d) {
            return window.x_axis(d.x) - 20;
        })
        .attr("y", function(d) {
            return window.y_axis(d.y) - 15;
        })
        .text(function(d) {
            return "( " + d.x + " , " + d.y + " )";
        })
        .attr("font-family", "arial")
        .attr("font-size", "10px")
        .attr("fill", "black");

    /* =========== THE X GRID LINES =========== */

    // Add gridlines for the X axis
    svg.append("g")
        .attr("class", "grid")
        .attr("transform", "translate(0," + base_height + ")")
        .call(make_x_gridlines()
            .tickSize(-base_height)
            .tickFormat("")
        );

    // position labels in x axis function
    function make_x_gridlines() {
        return d3.axisBottom(x_axis).ticks(10);
    }

    /* =========== THE Y GRID LINES =========== */

    // Add gridlines for the Y axis
    svg.append("g")
        .attr("class", "grid")
        .call(make_y_gridlines()
            .tickSize(-base_width)
            .tickFormat("")
        );

    // position labels in Y axis function
    function make_y_gridlines() {
        return d3.axisLeft(y_axis).ticks(10);
    }

    /* =========== THE X AXIS =========== */

    // Add the X axis
    svg.append("g")
        .attr("transform", "translate(0," + base_height + ")")
        .call(d3.axisBottom(x_axis));

    // Add the label for the X axis
    svg.append("text")
        .attr("transform", "translate(" + (base_width / 2) + " ," + (base_height + margin.top + 25) + ")")
        .style("text-anchor", "middle")
        .text("X axis");

    /* =========== THE Y AXIS =========== */

    // Add the Y axis
    svg.append("g")
        .attr("class", "greenAxis")
        .call(d3.axisLeft(y_axis));

    // Add the label for the Y axis
    svg.append("text")
        .attr("transform", "rotate(-90)")
        .attr("y", 0 - margin.left)
        .attr("x", 0 - (base_height / 2))
        .attr("dy", "1em")
        .style("text-anchor", "middle")
        .text("Y axis");


    // Add the line path.
    var linePath = svg.append("path")
        .datum(dotData)
        .style("fill", "none")
        .style("stroke", "black")
        .style("stroke-width", "2px")
        .attr("d", d3.line()
            .x(function(d) {
                return window.x_axis(d.x);
            })
            .y(function(d) {
                return window.y_axis(d.y);
            }))
        .call(animate); // <-- call the animate() function

    // The animation function to animate a path between the chart points
    function animate(path) {
        path.transition()
            .duration(6000)
            .attrTween("stroke-dasharray", tween)
            .on("end", function() {
                d3.select(this).call(animate);
            });
    }

    // Here we specify the tweeening function for our line drawing
    function tween() {
        var lineLength = this.getTotalLength();
        var interpolated = d3.interpolateString("0," + lineLength, lineLength + "," + lineLength);
        return function(t) {
            return interpolated(t);
        };
    }


    // Add the label with clicked point information
    var dynamicText = svg.append("text")
        .attr("x", base_width / 2)
        .attr("y", base_height + 70)
        .attr("dy", "1em")
        .style("text-anchor", "middle")
        .style("fill", "red")
        .style("font-weight", "bold")
        .text("Click a point on the chart to get info");

    // We are adding the rectangles on our SVG
    var rects = svg.selectAll("rect")
        .data(dotData)
        .enter()
        .append("rect")
        .on("click", onClick);

    function onClick(d) {
        dynamicText.text("X = " + d.x + ", Y = " + d.y + "  ---  data: " + d.description);
    }

    // Here we specify the atrtritbutes of the rectangles
    var rectAttr = rects.attr("x", function(d) {
        return window.x_axis(d.x) - d.width / 2;
    })
        .attr("y", function(d) {
            return window.y_axis(d.y) - d.height / 2;
        })
        .attr("rx", function(d) {
            return d.rx;
        })
        .attr("ry", function(d) {
            return d.ry;
        })
        .attr("width", function(d) {
            return d.width;
        })
        .attr("height", function(d) {
            return d.height;
        })
        .style("fill", function(d) {
            return d.color;
        });

    // add eventListener for tizenhwkey
    document.addEventListener("tizenhwkey", function(e) {
        if (e.keyName === "back") {
            try {
                tizen.application.getCurrentApplication().exit();
            } catch (ignore) {}
        }
    });

};