#ifndef CALENDAR_UTILS_H_
#define CALENDAR_UTILS_H_

#include <calendar.h>
#include <time.h>

/**
 * Status data
 */
typedef struct
{
    const char *name;
    calendar_todo_status_e type;
}status_data;

/**
 * Status info array
 */
static const status_data status_info[] =
{
	    {"None", CALENDAR_TODO_STATUS_NONE},
	    {"Needs action", CALENDAR_TODO_STATUS_NEEDS_ACTION},
	    {"Completed", CALENDAR_TODO_STATUS_COMPLETED},
	    {"In progress", CALENDAR_TODO_STATUS_IN_PROCESS},
	    {"Cancelled", CALENDAR_TODO_STATUS_CANCELED}
};

static const int status_info_size = sizeof(status_info)/sizeof(status_data);

void create_test_todo_task(char *summary, long long int startTime);

void set_todo_status(calendar_record_h record, calendar_todo_status_e todo_status);

void set_start_time(calendar_record_h record, struct tm task_start_date);

int get_status_of_task(calendar_record_h record);

const char *get_status_name_of_task(int status);

char *get_name_of_task(calendar_record_h record);

struct tm get_start_date_of_task(calendar_record_h record);

calendar_record_h get_todo_record(int record_index);

#endif /* CALENDAR_UTILS_H_ */
