var app = angular.module('myApp', []);
app.controller('sqlController', function($scope) {
	var db, version, dbName, dbDisplayName, dbSize;
	
	$scope.dataRecords = [];
	var progressBar = document.getElementById("progressbar"),progressBarWidget;
	var dataObj= {
			 "id": "",
			 "title": "",
			 "content": "",
			 "insertDay": ""
	 };
	 
	 function clone(obj) {
		    if (null == obj || "object" != typeof obj) return obj;
		    var copy = obj.constructor();
		    for (var attr in obj) {
		        if (obj.hasOwnProperty(attr)) copy[attr] = obj[attr];
		    }
		    return copy;
	 };
	
	$scope.exitApp = function(){
		tizen.application.getCurrentApplication().exit();
	};
	
	$scope.backToHome = function(){
		$scope.CurrentPage = 'Home';
		$scope.view = false;
		$scope.add = false;
	    $scope.home = true;
		
	};
	
	$scope.goAdd = function(){
	    $scope.home = false;
	    $scope.view = false;
		$scope.add = true;
		$scope.CurrentPage = 'Add';
		
	};
	
	$scope.goList = function(){
		$scope.home = false;
	    $scope.add = false;
	    $scope.view = true;
	    $scope.CurrentPage = 'List';
		
	};
	
	$scope.goView = function(){
		$scope.home = false;
	    $scope.add = false;
	    $scope.view = true;
	    $scope.CurrentPage = 'View';
		
	};
	
	$scope.save = function(){
		//console.log($scope.obj.content);
		//console.log($scope.obj.title);
		insertData(db, $scope.obj.title, $scope.obj.content);
		dataView(db);
		$scope.obj.content='';
		$scope.obj.title='';
		var element = document.getElementById("listvi"),
	    listv = tau.widget.Listview(element);
	    listv.refresh();
		//$scope.backToHome();
	};
	
	$scope.getItem = function(id){
		console.log(id);
		getDatabyId(db, id);
	};
	

	
	//create Table
	function createTable(db) {
		db
				.transaction(function(t) {
					t
							.executeSql(
									"CREATE TABLE tizenTable (id INTEGER PRIMARY KEY, title TEXT, content TEXT, insertDay DATETIME)",
									[]);
				});
	}
	
	// drop table
	function dropTable(db) {
		db.transaction(function(e) {
			e.executeSql("DROP TABLE tizenTable");
		});
	}
	
	//inserting data in table
	function insertData(db, title, context) {
		db
				.transaction(function(e) {
					var day = new Date();
					e
							.executeSql(
									"INSERT INTO tizenTable(title, content, insertDay) VALUES (?, ?, ?)",
									[ title, context, day ], onSuccess, onError);
				});
	}
	
	function onSuccess(e) {
		console.log("Successfully inserted data");
	}
	function onError(e) {
		console.log("Unable to insert data");
	}
	
	function updatePage(e) {
	
	}
	
	//reads and displays values from the 'places' table
	function dataView(db) {
		//var html = document.getElementById("expandbody");
		//html.innerHTML = "";
		var counter=0, size;
		db.transaction(function(t) {
			t.executeSql("SELECT * FROM tizenTable", [], function(tran, r) {
				for (var i = 0; i < r.rows.length; i++) {
					counter++;
					size=r.rows.length;
					dataObj.id=r.rows.item(i).id;
					dataObj.title=r.rows.item(i).title;
					dataObj.content=r.rows.item(i).content;
					dataObj.insertday=r.rows.item(i).insertday;
					var temp = clone(dataObj);
					$scope.dataRecords.push(temp);
				}
			}, function(t, e) {
				alert("Error:" + e.message);
			});
		});
		
		if(counter+1 == size){
			updatePage();				
		}
	}
	
	function getDatabyId(db, id) {
		//var html = document.getElementById("expandbody");
		//html.innerHTML = "";

		db.transaction(function(t) {
			t.executeSql("SELECT * FROM tizenTable where id=?", [id], function(tran, r) {
				for (var i = 0; i < r.rows.length; i++) {
					/*var id = r.rows.item(i).id;
					var title = r.rows.item(i).title;
					var content = r.rows.item(i).content;
					var insertday = r.rows.item(i).insertDay;
					//data list rendering
					if (html) {
						html.innerHTML +="<li class='ui-expandable'>"
				               +"<h2 class='listHeader'>"+title+"</h2>"
				                +"<ul class='ui-listview'>"
							      +"<li class='ui-li-static'>"+id+"</li>"
							      +"<li class='ui-li-static'>"+content+"</li>"
							      +"<li class='ui-li-static'>"+insertday+"</li>"
							    +"</ul>"
							   +"</li>";
					}
					*/
					dataObj.id=r.rows.item(i).id;
					dataObj.title=r.rows.item(i).title;
					dataObj.content=r.rows.item(i).content;
					dataObj.insertday=r.rows.item(i).insertday;
					var temp = clone(dataObj);
					$scope.Object =temp;
					$scope.goView();

				}
			}, function(t, e) {
				alert("Error:" + e.message);
			});
		});
	}
	
	function selectDB() {
		if (window.openDatabase) {
			//openDatabase(name, version, displayname, estimatedsize, callback);
			db = openDatabase(dbName, version, dbDisplayName, dbSize);

			dropTable(db);
			createTable(db);

			//inserting data in table
			insertData(db, "tizenTest01",
					"We are pleased to announce that Tizen 3.0");
			insertData(db, "tizenTest02",
					"device vendors. We encourage you to download");
			insertData(db, "tizenTest03",
					"installed and used it. If you have questions");
			insertData(db, "tizenTest04", "This release includes many new features");
			insertData(db, "tizenTest05", "Highlights of this release include");
			insertData(db, "tizenTest06", "Highlights of this release include");
			insertData(db, "tizenTest07", "Highlights of this release include");
			insertData(db, "tizenTest08", "Highlights of this release include");
			insertData(db, "tizenTest09", "Highlights of this release include");
			insertData(db, "tizenTest10", "Highlights of this release include");
			insertData(db, "tizenTest11", "Highlights of this release include");

			dataView(db);

		} else {
			alert("Web SQL Database not supported in this device");
		}
	}
	
	var initDatabase = function(){
		//database varsion setting
		 version = 1.0;
		//database name setting
		 dbName = "tizendb";
		//database display name setting
		 dbDisplayName = "tizen_test_db";
		//database size setting
		 dbSize = 2 * 1024 * 1024;
		 selectDB();
	};
	
	$scope.welcome = function(){
		var element = document.getElementById("listvi"),
	    listv = tau.widget.Listview(element);
	    listv.refresh();
		$scope.CurrentPage = 'Home';
		$scope.add = false;
		$scope.view = false;
	    $scope.welcomepopup = false;
		$scope.home = true;
	};
	
	var init = function(){
	    $scope.welcomepopup = true;
	    initDatabase();
	};
	
	init();
});



	