/*******************************************************************************
 * Text element drawn on the Raphael paper
 *
 * @author Zaneta Szymanska <<ahref='mailto:z.szymanska@samsung.com'>z.szymanska@samsung.com</a>>
 *
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 ******************************************************************************/
"use strict";
var TextObject = function(paper) {
    this.paper = paper;
    // Type of the element
    this.type = "text";

    this.element = this.paper.text(300, 300, textContent);

    // Sets attributes of created element (using values defined in
    // properties.js)
    this.element.attr({
        "fill" : font.color,
        "font-size" : font.size,
        "font-weight" : font.weight,
        "font-style" : font.style
    });

    this.element.content = textContent;

    // Initial values of applied transforms
    this.element.t = [ 0, 0 ]; // translation
    this.element.r = 0; // rotation

    // Position of the element, by default 300, 300
    this.element.translated = {
        x : this.element.attr("x"),
        y : this.element.attr("y")
    };

    // Center point of text
    this.element.centrePoint = null;

    // Elements used to rotation and translation of the text
    this.element.rotatePoint = null;
    this.element.translationPoint = null;

    collage.setItemSelected(this.element);

    this.element.drag(null, function() {
        // Event handler for drag of the element
        var that = this;
        collage.setItemSelected(that);
    }, null);
};