/*******************************************************************************
 * Image element drawn on the Raphael paper
 *
 * @author Zaneta Szymanska <<ahref='mailto:z.szymanska@samsung.com'>z.szymanska@samsung.com</a>>
 *
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 ******************************************************************************/
"use strict";
var ImageObject = function(paper, src, width, height) {
    this.paper = paper;
    // Type of the element
    this.type = "image";

    this.element = this.paper.image(src, 100, 100, width, height);

    // Sets attributes of created element (using values defined in
    // properties.js)
    this.element.attr(elementProperties);

    // Initial values of applied transforms
    this.element.t = [ 0, 0 ]; // translation
    this.element.s = [ 1, 1 ]; // scaling
    this.element.r = 0; // rotation

    // Position of the element, by default 100, 100
    this.element.translated = {
        x : this.element.attr("x"),
        y : this.element.attr("y")
    };

    // Scaled size of the element
    this.element.scaledWidth = this.element.attr("width");
    this.element.scaledHeight = this.element.attr("height");

    // Center point of the image
    this.element.centrePoint = null;

    // Elements used to rotation and scaling of the element
    this.element.rotatePoint = null;
    this.element.scalePoint = null;

    // Properties of the glow applied to the element
    this.element.glowProp = null;
    // Set of elements which create glow-like effect for the element
    this.element.g = null;

    // Event handlers for drag of the element
    this.element.drag(transforms.move, transforms.start, transforms.up);

    collage.setItemSelected(this.element);

    /**
     * Removes glow-like effect connected with the element
     */
    this.element.removeGlow = function() {
        if (this.g && (this.g !== null)) {
            this.g.remove();
            this.g = null;
        }
    };

    /**
     * Restores glow-like effect to the element using defined glowProp of the
     * element
     */
    this.element.restoreGlow = function() {
        if (this.glowProp !== null) {
            this.g = this.glow(this.glowProp);
        }
    };

    /**
     * Removes and restores glow-like effect around the element
     */
    this.element.refreshGlow = function() {
        if (this.g && (this.g !== null)) {
            this.g.remove();
            this.g = null;
        }

        if (this.glowProp !== null) {
            this.g = this.glow(this.glowProp);
        }
    };
};