/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using Xamarin.Forms;

namespace ClockUI
{
    /// <summary>
    /// the main entry of the ClockUI
    /// </summary>
    public class App : Application
    {
        /// <summary>
        /// list view source data struct
        /// </summary>
        class MyCell
        {
            public MyCell(string time, string city, string date, string country)
            {
               //Initialize property of time
                this.Time = time;
               //Initialize property of city
                this.City = city;
               //Initialize property of date
                this.Date = date;
               //Initialize property of country
                this.Country = country;
            }

            /// <summary>
            /// City property. </summary>
            /// <value>
            /// A value tag is used to describe the property value.</value>
            public string City { get; private set; }

            /// <summary>
            /// Country property. </summary>
            /// <value>
            /// A value tag is used to describe the property value.</value>
            public string Country { get; private set; }

            /// <summary>
            /// Date property. </summary>
            /// <value>
            /// A value tag is used to describe the property value.</value>
            public string Date { get; private set; }

            /// <summary>
            /// Time property. </summary>
            /// <value>
            /// A value tag is used to describe the property value.</value>
            public string Time { get; private set; }
        };

        // resource name
        static string IconAlarm = "icon_alarm.png";
        static string IconClock = "icon_worldclock.png";
        static string IconTimer = "icon_timer.png";

        /// <summary>
        /// the class Constructor
        /// </summary>
        public App()
        {
            // create three tab page of your application
            Page Alarm = CreateAlarm();
            Page Worldclock = CreateWorldclock();
            Page Timer = CreateTimer();

            // The root page of your application
            // add three tab page of your application
            MainPage = new TabbedPage
            {
                Children =
                {
                    Alarm,
                    Worldclock,
                    Timer,
                }
            };
        }

        //Alarm page of ClockUI
        public static ContentPage CreateAlarm()
        {
            Grid grid1 = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                RowSpacing = 10,
            };
            grid1.Children.Add(
                new Label()
                {
                    Text = "07:26",
                    FontSize = 80,
                    HorizontalOptions = LayoutOptions.Center,
                    VerticalOptions = LayoutOptions.End,
                }, 0, 0);

            grid1.Children.Add(
                new Label()
                {
                    Text = "Wed,January1",
                    HorizontalOptions = LayoutOptions.Center,
                    VerticalOptions = LayoutOptions.Start,
                }, 0, 1);

            Grid grid2 = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.EndAndExpand,
            };

            //add the image source
            Image largeImage = new Image()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                Source = "no_alarm.png",
            };
            grid2.Children.Add(largeImage, 0, 0);

            grid2.Children.Add(
                new Label()
                {
                    Text = "No alarms",
                    HorizontalOptions = LayoutOptions.Center,
                }, 0, 1);

            // return content of the page
            return new ContentPage()
            {
               // set the title of tabpage
                Title = "Alarm",
               // set the icon source of tabpage
                Icon = IconAlarm,
                Content = new StackLayout()
                {
                    Children =
                    {
                        grid1,
                        grid2,
                        //set the button at bottom  of the page
                        new Button()
                        {
                            Text = "Create alarm",
                            VerticalOptions = LayoutOptions.End,
                            HorizontalOptions = LayoutOptions.Fill,
                        },
                    },
                }
            };
        }

        /// <summary>
        /// WorldClock page of ClockUI
        /// </summary>
        /// <returns> return the created worldclock page </returns>
        public static ContentPage CreateWorldclock()
        {

            Grid grid1 = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                //set row space of the grid
                RowSpacing = 5,
            };

            grid1.Children.Add(
                new Label()
                {
                    Text = "07:26",
                    FontSize = 80,
                    HorizontalOptions = LayoutOptions.Center,
                    VerticalOptions = LayoutOptions.End,
                }, 0, 0);


            grid1.Children.Add(
                new Label()
                {
                    Text = "Cardiff,Wales",
                    TextColor = Color.Green,
                    HorizontalOptions = LayoutOptions.Center,
                    VerticalOptions = LayoutOptions.Start,
                }, 0, 1);

            grid1.Children.Add(
                new Label()
                {
                    Text = "Wed,January1",
                    HorizontalOptions = LayoutOptions.Center,
                    VerticalOptions = LayoutOptions.Start,
                }, 0, 2);

            Grid grid2 = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                //set the grid space of column and row
                ColumnSpacing = 5,
                RowSpacing = 5,
            };

            int num_of_item = 3;
            string buf1, buf2, buf3, buf4;

           //list view source
            List<MyCell> mylist = new List<MyCell>();
            for (int i = 0; i < num_of_item; i++)
            {
                if (i == 0)
                {
                    buf1 = "07:26";
                    buf2 = "Cardiff";
                    buf3 = "Wed, Jan 1";
                    buf4 = "Wales";
                }
                else if (i == 1)
                {
                    buf1 = "08:26";
                    buf2 = "Beijing";
                    buf3 = "Wed, Jan 1";
                    buf4 = "China";
                }
                else
                {
                    buf1 = "09:26";
                    buf2 = "Tokyo";
                    buf3 = "Wed, Jan 1";
                    buf4 = "Japan";
                }

                //add listview resource data of each item
                mylist.Add(new MyCell(buf1, buf2, buf3, buf4));
            }

            ListView listView = new ListView()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                ItemsSource = mylist,
                RowHeight = 100,
                ItemTemplate = new DataTemplate(() =>
                {
                    Label timeLabel = new Label { TextColor = Color.Black };
                    timeLabel.SetBinding(Label.TextProperty, "Time");
                    Label cityLabel = new Label { TextColor = Color.Black };
                    cityLabel.SetBinding(Label.TextProperty, "City");
                    Label dateLabel = new Label { TextColor = Color.Black };
                    dateLabel.SetBinding(Label.TextProperty, "Date");
                    Label countryLabel = new Label { TextColor = Color.Black };
                    countryLabel.SetBinding(Label.TextProperty, "Country");
                    return new ViewCell
                    {
                        View = new StackLayout
                        {
                            Padding = new Thickness(0, 5),
                            Orientation = StackOrientation.Horizontal,
                            Children =
                            {
                                new StackLayout
                                {
                                    VerticalOptions = LayoutOptions.Start,
                                    Spacing = 0,
                                    Children =
                                    {
                                        timeLabel,
                                        dateLabel
                                    }
                                },
                                new StackLayout
                                {
                                    VerticalOptions = LayoutOptions.Start,
                                    HorizontalOptions = LayoutOptions.EndAndExpand,
                                    Spacing = 0,
                                    Children =
                                    {
                                        cityLabel,
                                        countryLabel
                                    }
                                }
                            }
                        }
                    };

                })
            };

            grid2.Children.AddVertical(listView);

            // return content of the page
            return new ContentPage()
            {
               // set the title of tabpage
                Title = "World Clock",
               // set the icon source of tabpage
                Icon = IconClock,
                Content = new StackLayout()
                {
                    Children =
                        {
                           grid1,
                           grid2,
                           //set the button at bottom  of the page
                           new Button()
                           {
                                Text = "Add city",
                                VerticalOptions = LayoutOptions.End,
                                HorizontalOptions = LayoutOptions.Fill,
                           },
                        },
                }

            };

        }

        /// <summary>
        /// Timer page of ClockUI
        /// </summary>
        /// <returns> return the created timer page </returns>
        public static ContentPage CreateTimer()
        {
            Grid grid1 = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                RowSpacing = 10,
            };

            grid1.Children.Add(
                new Label()
                {
                    Text = "Hour   Min   Sec",
                    FontSize = 35,
                    HorizontalOptions = LayoutOptions.Center,
                    VerticalOptions = LayoutOptions.End,
                }, 0, 0);

            grid1.Children.Add(
                new Label()
                {
                    Text = "00:00:00",
                    FontSize = 120,
                    HorizontalOptions = LayoutOptions.Center,
                    VerticalOptions = LayoutOptions.Start,
                }, 0, 1);

            Grid grid2 = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                ColumnSpacing = 5,
                RowSpacing = 5,
            };

            int index = 0;
            string buf;
            for (int i = 0; i < 4; i++)
            {
                for (int j = 0; j < 3; j++)
                {
                    index++;
                    if (index == 10)
                    {
                        buf = "Del";
                    }
                    else if (index == 11)
                    {
                        buf = "0";
                    }
                    else if (index == 12)
                    {
                        buf = "Next";
                    }
                    else
                    {
                        buf = index.ToString();
                    }

                    Button btn = new Button()
                    {
                        Text = buf,
                        FontSize = 50,
                        HorizontalOptions = LayoutOptions.FillAndExpand,
                        VerticalOptions = LayoutOptions.FillAndExpand,
                        MinimumHeightRequest = 100,
                        MinimumWidthRequest = 150,
                    };
                    //add a button to the appoint column ,row of grid
                    grid2.Children.Add(btn, j, i);
                }
            }

            // return content of the page
            return new ContentPage()
            {
                // set the title of contentpage
                Title = "Timer",
               // set the icon source of tabpage
                Icon = IconTimer,
                Content = new StackLayout()
                {
                    Children =
                    {
                        grid1,
                        grid2,
                        //set the button at bottom  of the page
                        new Button()
                        {
                            Text = "Start",
                            VerticalOptions = LayoutOptions.End,
                            HorizontalOptions = LayoutOptions.Fill,
                        },
                   }
                }
            };
        }

        protected override void OnStart()
        {
            // Handle when your app starts
        }

        protected override void OnSleep()
        {
            // Handle when your app sleeps
        }

        protected override void OnResume()
        {
            // Handle when your app resumes
        }
    }
}
