/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;
using Clock.Styles;
using Xamarin.Forms.PlatformConfiguration.TizenSpecific;
using Label = Xamarin.Forms.Label;

namespace Clock.Worldclock
{
    public class WorldclockCityListCell : ViewCell
    {
        private StackLayout mainListItemLayout;
        private RelativeLayout cityListItemLayout;
        private Label timeLabel;
        private Label amPmLabel;
        private Label dateLabel;
        private Label citiesLabel;
        private Label relativeToLocalLabel;

        public WorldclockCityListCell()
        {
            View = CreateCityList();
        }

        private StackLayout CreateCityList()
        {
            if (mainListItemLayout == null)
            {
                cityListItemLayout = new RelativeLayout
                {
                    WidthRequest = 720,
                    HeightRequest = 22 + 53 + 43 + 26,
                    //BackgroundColor = Color.FromHex("#0022dd"),
                };

                timeLabel = new Label
                {
                    Style = WorldclockStyle.ATO040,
                    WidthRequest = 113,
                    HeightRequest = 61, /*67*/// GUI GUIDE : 67
                    VerticalTextAlignment = TextAlignment.Center,
                    HorizontalTextAlignment = TextAlignment.Center,
                    //BackgroundColor = Color.Tomato,
                };
                timeLabel.On<Xamarin.Forms.PlatformConfiguration.Tizen>().SetFontWeight(FontWeight.Light);
                timeLabel.SetBinding(Label.TextProperty, "CityTime");

                cityListItemLayout.Children.Add(timeLabel,
                    Constraint.RelativeToParent((parent) =>
                    {
                        return 32;
                    }),
                    Constraint.RelativeToParent((parent) =>
                    {
                        return 17;
                    }));

                amPmLabel = new Label
                {
                    Style = WorldclockStyle.ATO041,
                    WidthRequest = 52,
                    HeightRequest = 40,
                    VerticalTextAlignment = TextAlignment.Center,
                    HorizontalTextAlignment = TextAlignment.Center,
                    //BackgroundColor = Color.Violet,
                };
                amPmLabel.On<Xamarin.Forms.PlatformConfiguration.Tizen>().SetFontWeight(FontWeight.Medium);
                amPmLabel.SetBinding(Label.TextProperty, "CityAmPm");
                cityListItemLayout.Children.Add(amPmLabel,
                    Constraint.RelativeToParent((parent) =>
                    {
                        return 32 + 113 + 8;
                    }),
                    Constraint.RelativeToParent((parent) =>
                    {
                        return 17 + 21;
                    }));

                dateLabel = new Label
                {
                    Style = WorldclockStyle.ATO042,
                    Text = "Wed, 20 Mar",
                    WidthRequest = 173,
                    HeightRequest = 40,
                    VerticalTextAlignment = TextAlignment.Center,
                    HorizontalTextAlignment = TextAlignment.Center,
                    //BackgroundColor = Color.Beige,
                };
                dateLabel.On<Xamarin.Forms.PlatformConfiguration.Tizen>().SetFontWeight(FontWeight.Normal);
                dateLabel.SetBinding(Label.TextProperty, "CityDate");
                cityListItemLayout.Children.Add(dateLabel,
                    Constraint.RelativeToParent((parent) =>
                    {
                        return 32;
                    }),
                    Constraint.RelativeToParent((parent) =>
                    {
                        return 17 + 61;
                    }));

                citiesLabel = new Label
                {
                    Style = WorldclockStyle.ATO043,
                    Text = "Beijing, China",
                    WidthRequest = 405,
                    HeightRequest = 53,
                    VerticalTextAlignment = TextAlignment.Center,
                    HorizontalTextAlignment = TextAlignment.Start,
                    //BackgroundColor = Color.SpringGreen,
                    LineBreakMode = LineBreakMode.TailTruncation,
                };
                citiesLabel.On<Xamarin.Forms.PlatformConfiguration.Tizen>().SetFontWeight(FontWeight.Normal);
                citiesLabel.SetBinding(Label.TextProperty, "Cities");
                cityListItemLayout.Children.Add(citiesLabel,
                    Constraint.RelativeToParent((parent) =>
                    {
                        return 32 + 173 + 82;
                    }),
                    Constraint.RelativeToParent((parent) =>
                    {
                        return 22;
                    }));

                relativeToLocalLabel = new Label
                {
                    Style = WorldclockStyle.ATO044,
                    Text = "Same as local time",
                    WidthRequest = 405,
                    HeightRequest = 43,
                    VerticalTextAlignment = TextAlignment.Center,
                    HorizontalTextAlignment = TextAlignment.Start,
                    //BackgroundColor = Color.Black,
                };
                relativeToLocalLabel.On<Xamarin.Forms.PlatformConfiguration.Tizen>().SetFontWeight(FontWeight.Normal);
                relativeToLocalLabel.SetBinding(Label.TextProperty, "RelativeToLocalCountry");
                cityListItemLayout.Children.Add(relativeToLocalLabel,
                    Constraint.RelativeToParent((parent) =>
                    {
                        return 32 + 173 + 82;
                    }),
                    Constraint.RelativeToParent((parent) =>
                    {
                        return 22 + 53;
                    }));

                mainListItemLayout = new StackLayout
                {
                    Orientation = StackOrientation.Vertical,
                    Spacing = 0,
                    HorizontalOptions = LayoutOptions.FillAndExpand,
                    VerticalOptions = LayoutOptions.FillAndExpand,
                    //BackgroundColor = Color.Pink,
                    Children =
                    {
                        cityListItemLayout
                    }
                };
            }

            return mainListItemLayout;
        }

        protected override void OnBindingContextChanged()
        {
            base.OnBindingContextChanged();
        }

    }
}
