﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace Clock.Interfaces
{
    /// <summary>
    /// The DebugMessage Interface
    /// </summary>
    public interface IDebugMessage
    {
        /// <summary>
        /// Prints a log message with the DEBUG priority
        /// It can be checked with dlogutil command
        /// </summary>
        /// <param name="message">A debug message</param>
        void Debug(string message);

        /// <summary>
        /// Prints a log message with the ERROR priority
        /// /// It can be checked with dlogutil command
        /// </summary>
        /// <param name="message">An error message</param>
        void Error(string message);

        /// <summary>
        /// Displays a dialog with a log message
        /// </summary>
        /// <param name="message">A log message</param>
        void DisplayLogWindow(string message);
    }
}
