﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Button = Xamarin.Forms.Button;
using Color = Xamarin.Forms.Color;
using Label = Xamarin.Forms.Label;
using Tizen;
using Tizen.Xamarin.Forms.Extension;

#if CROSS_PLATFORM
using Clock.Interfaces;

[assembly: Xamarin.Forms.Dependency(typeof(DebugMessage))]
#endif
namespace Clock.Tizen.Impls
{
    /// <summary>
    /// The DebugginMessage class
    /// </summary>
#if CROSS_PLATFORM
    class DebugMessage : IDebugMessage
#else
    class DebugMessage
#endif
    {
        /// <summary>
        /// A Logging Tag
        /// </summary>
        public static string TAG = "CLOCK#";
        static Dialog dialog = null;
        static Label label = null;

        /// <summary>
        /// Prints a log message with the DEBUG priority
        /// </summary>
        /// <param name="message">A debug message</param>
        public static void Debug(string message)
        {
            Log.Debug(TAG, message);
        }

        /// <summary>
        /// Prints a log message with the ERROR priority
        /// </summary>
        /// <param name="message">An error message</param>
        public static void Error(string message)
        {
            Log.Debug(TAG, message);
        }


        /// <summary>
        /// Displays a dialog with a log message
        /// </summary>
        /// <param name="message">A log message</param>
        public static void DisplayLogWindow(string message)
        {
#if CROSS_PLATFORM
            DependencyService.Get<IDebugMessage>().Debug("[DisplayLogWindow] message : "+ message);
#else
            DebugMessage.Debug("[DisplayLogWindow] message : "+ message);
#endif
            if (dialog == null)
            {
                label = new Label()
                {
                    TextColor = Color.Red,
                };
                dialog = new Dialog();
                dialog.Title = "Debugging Message";
                var positive = new Button()
                {
                    Text = "OK"
                };
                dialog.Positive = positive;
                positive.Clicked += Positive_Clicked;
                dialog.Content = label;
            }
            label.Text = message;
            dialog.Show();
        }

        private static void Positive_Clicked(object sender, System.EventArgs e)
        {
            dialog.Dismiss();
        }
    }
}
