/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Clock.Styles;
#if CROSS_PLATFORM
#else
using Clock.Tizen;
#endif
using System.Collections.Generic;
using Xamarin.Forms;

namespace Clock.Worldclock
{
    public class WorldclockCityList
    {
        public const int MAX_ITEMS_LIMIT = 20;
        //public List<Location> userLocations = new List<Location>();
        public WorldclockCityListUI cityListUI;
        public StackLayout emptyListAreaLayout;
        Label emptyListLabel;

        public WorldclockCityList()
        {
            CreateEmptyListPage();
            cityListUI = new WorldclockCityListUI();
        }

        private void CreateEmptyListPage()
        {
            if (emptyListAreaLayout == null)
            {
                emptyListAreaLayout = new StackLayout()
                {
                    Spacing = 0,
                    HorizontalOptions = LayoutOptions.FillAndExpand,
                    VerticalOptions = LayoutOptions.FillAndExpand,
                    //HeightRequest = 1113 - 679,
                    WidthRequest = 720,
                    BackgroundColor = Color.White,
                };

                emptyListLabel = new Label
                {
                    Text = "After you add cities, they\r\nwill be shown here.",
                    //BackgroundColor = Color.FromHex("#0099aa"),
                    WidthRequest = 720 - 181 - 181,
                    HeightRequest = 43 + 43,
                    VerticalTextAlignment = TextAlignment.Center,
                    HorizontalTextAlignment = TextAlignment.Center,
                    // TODO: THERE IS NO GUIDELINE FOR FONT
                    // From native clock app, base: "font=Tizen:style=Regular color=#808080aa font_size=34 align=center"; 
                    TextColor = Color.FromHex("#808080aa"),
                    FontSize = CommonStyle.GetDp(31),
                    Margin = new Thickness(181, 452 / 2 - 43, 181, 452 / 2 - 43),
                };

                emptyListAreaLayout.Children.Add(emptyListLabel);
            }
        }

        public void AppendItemToCustomList(Location item)
        {
            App currentApp = Application.Current as App;
            CityRecord cityRecord = currentApp.ClockInfo.GetCityRecord(item.gmtOffset);
            cityRecord.Cities = item.name + ", " + item.country;
            var _item = new List<CityRecord>();
            _item.Add(cityRecord);
            CityRecord.cityRecordList.InsertRange(CityRecord.cityRecordList.Count, _item);
        }
    }
}
