/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System.Diagnostics;
using Native = Tizen.Applications;
using System;
using Xamarin.Forms;
using Clock.Common;
using System.Collections.Generic;
using Clock.Alarm;
using Clock.Interfaces;
using Tizen.Xamarin.Forms.Extension.Renderer;
using Size = ElmSharp.Size;

namespace Clock.Tizen.Tizen
{
    class Program : global::Xamarin.Forms.Platform.Tizen.FormsApplication
    {
        App app_;
        protected override void OnCreate()
        {
            base.OnCreate();
            MainWindow.AvailableOrientations = Xamarin.Forms.Platform.Tizen.Native.DisplayOrientations.Portrait;
            app_ = new App();
            LoadApplication(app_);
            Size screenSize = global::Xamarin.Forms.Platform.Tizen.Forms.Context.MainWindow.ScreenSize;
            app_.ScreenWidth = screenSize.Width;
            app_.ScreenHeight = screenSize.Height;
        }

        protected override void OnTerminate()
        {
            base.OnTerminate();
            app_.Terminate();
        }

        async protected override void OnAppControlReceived(Native.AppControlReceivedEventArgs e)
        {
            base.OnAppControlReceived(e);
            Native.AppControl appControl = e.ReceivedAppControl;
            try
            {
                if (appControl.ExtraData.Count() != 0)
                {
                    IEnumerable<string> stack1 = appControl.ExtraData.GetKeys();
                    string type = appControl.ExtraData.Get<string>("RingType");
                    if (type == RingType.RING_TYPE_ALARM.ToString())
                    {
                        var navi = app_.MainPage as NavigationPage;
                        var currentPage = navi.CurrentPage as MainTabbedPage;

                        string AlarmCreatedDate = appControl.ExtraData.Get<string>("AlarmRecord.UniqueIdentifier");
                        if (AlarmRecord.AlarmRecordDictionary == null)
                        {
                            // IAlarmPersistentHandler serizliazer = DependencyService.Get<IAlarmPersistentHandler>();
                            // Need to retrieve at the page creation time
                            AlarmRecord.AlarmRecordDictionary = Clock.Tizen.Impls.AlarmPersistentHandler.GetInstance().DeserializeAlarmRecord();
                        }

                        AlarmRecord retrievedRecord;
                        if (AlarmRecord.AlarmRecordDictionary != null)
                        {
                            if (AlarmRecord.AlarmRecordDictionary.TryGetValue(AlarmCreatedDate, out retrievedRecord))
                            {
                                if (retrievedRecord.AlarmState == AlarmStates.Active)
                                {
                                    await currentPage.Navigation.PushAsync(new RingPage(RingType.RING_TYPE_ALARM, retrievedRecord));
                                }
                            }
                        }
                    }
                    else if (type == RingType.RING_TYPE_TIMER.ToString())
                    {
                        var navi = app_.MainPage as NavigationPage;
                        var currentPage = navi.CurrentPage as MainTabbedPage;
                        await currentPage.Navigation.PushAsync(new RingPage(RingType.RING_TYPE_TIMER));
                    }
                }
            }
            catch (Exception ex)
            {
                Debug.WriteLine("Exception - Message:{0}", ex.Message);
            }
        }

        static void Main(string[] args)
        {
            var app = new Program();
            TizenFormsExtension.Init();
            global::Xamarin.Forms.Platform.Tizen.Forms.Init(app);
            app.Run(args);
        }
    }
}
