/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Globalization;
using Xamarin.Forms.Platform.Tizen;
using Xamarin.Forms.Platform.Tizen.Native;
using Clock.Tizen;
using Clock.Controls;
using EColor = ElmSharp.Color;

[assembly: ExportRenderer(typeof(TizenTimePicker), typeof(TizenTimePickerRenderer))]
namespace Clock.Tizen
{
    class TizenTimePickerRenderer : ViewRenderer<TizenTimePicker, TimePicker>
    {
        static readonly string s_defaultFormat = CultureInfo.CurrentCulture.DateTimeFormat.ShortTimePattern;
        static readonly EColor s_defaultTextColor = EColor.White;
        string _format;
        TimePicker _timePicker;

        public TizenTimePickerRenderer()
        {
            RegisterPropertyHandler(TizenTimePicker.TimeProperty, UpdateTimeToXamarinForms);
        }

        protected override void OnElementChanged(ElementChangedEventArgs<TizenTimePicker> e)
        {
            if (Control == null)
            {
                _format = s_defaultFormat;
                _timePicker = new TimePicker(Forms.Context.MainWindow)
                {
                    Time = DateTime.Now.TimeOfDay,
                    DateTimeFormat = _format,
                    // Added temporarily because of Tizen EFL limitation
                    Format = "%d/%b/%Y %I:%M %p"
                };
                _timePicker.DateTimeChanged += DateTimeChangedHandler;
                SetNativeControl(_timePicker);
            }

            base.OnElementChanged(e);
        }

        private void DateTimeChangedHandler(object sender, ElmSharp.DateChangedEventArgs e)
        {
            DateTime dt = e.NewDate;             // DateTime can be converted to TimeSpan via .TimeOfDay
            Control.Time = dt.TimeOfDay; // update Native wrapper and local variable
            Element.Time = Control.Time;
        }

        void UpdateTimeToXamarinForms()
        {
            Control.Time = Element.Time;
        }
    }
}
