/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Clock.Interfaces;
using Clock.Tizen.Impls;
using Native = Tizen.Applications;
#if CROSS_PLATFORM
[assembly: Xamarin.Forms.Dependency(typeof(AppTerminator))]
#endif
namespace Clock.Tizen.Impls
{
#if CROSS_PLATFORM
    class AppTerminator : IAppTerminator
#else
    class AppTerminator
#endif
    {
#if CROSS_PLATFORM
#else
        static AppTerminator singletonObj;

        private AppTerminator()
        {

        }

        public static AppTerminator GetInstance()
        {
            return singletonObj ?? (singletonObj = new AppTerminator());
        }
#endif
        /// <summary>
        /// Terminate the clock app.
        /// </summary>
        public void TerminateApp()
        {
            Native.Application.Current.Exit();
        }
    }
}
