/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if CROSS_PLATFORM
using Clock.Interfaces;
#else
using Clock.Tizen.Impls;
#endif
using Clock.Worldclock;
using Xamarin.Forms;
using Tizen.Xamarin.Forms.Extension;

namespace Clock.Tizen
{
    /// <summary>
    /// The clock application
    /// </summary>
    public class App : Application
    {
        internal static NavigationPage mainNavi;
        internal static MainTabbedPage mainTabbed;
        public int ScreenWidth;
        public int ScreenHeight;
        public FloatingButton floatingButton;

        /// <summary>
        /// Gets/Sets instance of the <see cref="WorldclockInfo"/> class.
        /// </summary>
        public WorldclockInfo ClockInfo
        {
            get; set;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="App"/> class.
        /// </summary>
        public App()
        {
            // The root page of your application
            mainTabbed = new MainTabbedPage();
            MainPage = new NavigationPage(mainTabbed);
            mainNavi = MainPage as NavigationPage;

            // Create a FloatingButton
            floatingButton = new FloatingButton();
            FloatingButtonItem item = new FloatingButtonItem();
            item.Icon = "alarm/clock_floating_icon.png";
            floatingButton.FirstButton = item;
        }

        /// <summary>
        /// Makes a floating button visible on alarm or worldclock page
        /// </summary>
        public void ShowFloatingButton(string title)
        {
            if (title == "Alarm")
            {
                floatingButton.FirstButton.Clicked += mainTabbed.Alarm_FloatingButton_Clicked;
            }
            else if (title == "World clock")
            {
                floatingButton.FirstButton.Clicked += mainTabbed.WorldClock_FloatingButton_Clicked;
            }
            else
            {
                return;
            }
            floatingButton.Show();
        }

        /// <summary>
        /// Makes a floating button invisible on stopwatch or timer page
        /// </summary>
        public void HideFloatingButton(string title)
        {
            floatingButton.Hide();
            if (title == "Alarm")
            {
                floatingButton.FirstButton.Clicked -= mainTabbed.Alarm_FloatingButton_Clicked;
            }
            else if (title == "World clock")
            {
                floatingButton.FirstButton.Clicked -= mainTabbed.WorldClock_FloatingButton_Clicked;
            }
            floatingButton.Hide();
        }

        /// <summary>
        /// Called when clock application terminates.
        /// It happens when clock application exits via BACK key
        /// </summary>
        public void Terminate()
        {
            if (ClockInfo != null)
            {
                ClockInfo.Dispose();
            }
        }

        /// <summary>
        /// Called when clock application starts.
        /// It happens when clock application is shown at first.
        /// </summary>
        protected override void OnStart()
        {
            // Handle when your app starts
        }

        /// <summary>
        /// Called when clock application sleeps.
        /// It happens when clock application goes background via HOME or BACK key
        /// </summary>
        protected override void OnSleep()
        {
            // Handle when your app sleeps
        }

        /// <summary>
        /// Called when clock application resumes.
        /// It happens when clock application goes foreground
        /// </summary>
        async protected override void OnResume()
        {
            // Handle when your app resumes
            App currentApp = Application.Current as App;
            if (currentApp.ScreenWidth != 720 || currentApp.ScreenHeight != 1280)
            {
                await mainNavi.DisplayAlert("Notice", "The app only works in HD mobile emulator.", "OK");
#if CROSS_PLATFORM
                DependencyService.Get<IAppTerminator>().TerminateApp();
#else
                AppTerminator.GetInstance().TerminateApp();
#endif
                return;
            }
        }
    }
}
