/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms.Platform.Tizen;
using Clock.Tizen;
using Clock.Controls;

[assembly: ExportRenderer(typeof(ExtendedButton), typeof(ExtendedButtonRenderer))]

namespace Clock.Tizen
{
    /// <summary>
    /// The Renderer class of a ExtendedButton widget
    /// It extends ButtonRenderer class.
    class ExtendedButtonRenderer : ButtonRenderer
    {
        /// <summary>
        /// The constructor of ExtendedButtonRenderer class
        /// Register propertyHandler for applying button style
        /// </summary>
        public ExtendedButtonRenderer()
        {
            RegisterPropertyHandler(ExtendedButton.ButtonStyleProperty, UpdateButtonStyle);
        }

        /// <summary>
        /// Updates the Style property of a ExtendedButton widget.
        /// </summary>
        void UpdateButtonStyle()
        {
            var el = this.Element as ExtendedButton;
            if (el.ButtonStyle == ButtonStyle.NaviframeTitleLeft)
            {
                Control.Style = "naviframe/title_left";
            }
            else if (el.ButtonStyle == ButtonStyle.NaviframeTitleRight)
            {
                Control.Style = "naviframe/title_right";
            }
            else
            {
                Control.Style = "default";
            }
        }
    }
}
