/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;
using System;
using Clock.Alarm;

namespace Clock.Controls
{
    public class TizenTimePicker : View//, IElementConfiguration<TizenTimePicker>
    {
        public static readonly BindableProperty TimeProperty = BindableProperty.Create(nameof(Time), typeof(TimeSpan), typeof(TizenTimePicker), new TimeSpan(0), BindingMode.TwoWay, (bindable, value) =>
        {
            var time = (TimeSpan)value;
            return time.TotalHours < 24 && time.TotalMilliseconds >= 0;
        });
        private AlarmRecord alarmRecordData;

        //readonly Lazy<PlatformConfigurationRegistry<TimePickerCore>> _platformConfigurationRegistry;

        ///<summary>
        ///Initializes a new instance of the <see cref="TizenTimePicker"/> class
        ///</summary>
        public TizenTimePicker()
        {
            Time = DateTime.Now.TimeOfDay;
        }

        public TizenTimePicker(AlarmRecord alarmRecordData)
        {
            this.alarmRecordData = alarmRecordData;
            Time = alarmRecordData.ScheduledDateTime.TimeOfDay;
        }

        public TimeSpan Time
        {
            get { return (TimeSpan)GetValue(TimeProperty); }
            set { SetValue(TimeProperty, value); }
        }

//        public IPlatformElementConfiguration<T, TimePickerCore> On<T>() where T : IConfigPlatform
//        {
//            return _platformConfigurationRegistry.Value.On<T>();
//        }
    }
}
