/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;

namespace Clock.Controls
{
    /// <summary>
    /// The ExtendedButton class which extends Xamarin.Forms.Button
    /// This class has Button style
    /// </summary>
    public class ExtendedButton : Button
    {
        /// <summary>
        /// Backing store for the ButtonStyle bindable property.
        /// </summary>
        public static readonly BindableProperty ButtonStyleProperty = BindableProperty.Create("ButtonStyle", typeof(ButtonStyle), typeof(Button), ButtonStyle.None);//,

        /// <summary>
        /// Gets or sets the style of button.
        /// This is a bindable property.
        /// </summary>
        public ButtonStyle ButtonStyle
        {
            get { return (ButtonStyle)GetValue(ButtonStyleProperty); }
            set { SetValue(ButtonStyleProperty, value); }
        }
    }
}
