﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using Xamarin.Forms;

namespace Clock.Alarm
{
    /// <summary>
    /// This class defines alarm edit sound row UI.
    /// This row is only for sound row
    /// </summary>
    class AlarmEditSoundRow : RelativeLayout
    {
        internal Slider slider;

        /// <summary>
        /// Constructor for this class
        /// It defines UIs for this row
        /// </summary>
        public AlarmEditSoundRow()
        {
            HorizontalOptions = LayoutOptions.FillAndExpand;
            VerticalOptions = LayoutOptions.Start;
            HeightRequest = 120;
            /// volume image beside slider
            Image volumeImage = new Image()
            {
                Source = "clock_sound_volume_icon.png",
                HeightRequest = 50,
                WidthRequest = 50
            };
            /// slider to adjust volume
            slider = new Slider()
            {
                WidthRequest = 720 - (32 + 50 + 32 + 32)
            };
            slider.Value = AlarmEditPage.BindableAlarmRecord.Volume;

            //TODO Slider bindable is not working
            //slider.SetBinding(Slider.ValueProperty, new Binding("Volume", mode: BindingMode.TwoWay, converter: new AlarmValueConverter()));
            //slider.BindingContext = alarmRecord;

            // TODO: UI to model (opposite) binding needed
            slider.ValueChanged += (s,e) =>
            {
                /// Need to update BindableAlarmRecord to change model value
                AlarmEditPage.BindableAlarmRecord.Volume = Convert.ToSingle(e.NewValue);
            };

            Children.Add(volumeImage,
                Constraint.RelativeToParent((parent) => { return 32; }),
                Constraint.RelativeToParent((parent) => { return (120 - 50) / 2; }));

            Children.Add(slider,
                Constraint.RelativeToParent((parent) => { return 32 + 50 + 32; }),
                Constraint.RelativeToParent((parent) => { return (120 - slider.Height) / 2; }));
        }
    }
}
