self.addEventListener('message', function(evt) {
	
	var obj = evt.data,
		imgW = obj.imgW,
		imgH = obj.imgH,
		orginalData = obj.orginalData,
		dotSize = obj.dotSize,
		dotSize2 = obj.dotSize2,
		circlesData = [];

	for (var y = 0; y < imgH; y+=dotSize) { 
		for (var x = 0; x < imgW; x+=dotSize) {
            var o = {},
            	pixData = new Int32Array(3),
            	x2, y2;
            
			for(var i=0, dots=0; i<dotSize2 ;++i) {
				x2 = x + i % dotSize;
				y2 = y + Math.floor(i/dotSize);
				if(x2<=imgW && y2<=imgH) {
                    ++dots;
                    var ci = (x2+imgW*(imgH-y2))*4;
                    pixData[0] += orginalData.data[ci];
                    pixData[1] += orginalData.data[ci+1];
                    pixData[2] += orginalData.data[ci+2];
                }
			}

			pixData[0] = Math.floor(pixData[0]/dots);
			pixData[1] = Math.floor(pixData[1]/dots);
			pixData[2] = Math.floor(pixData[2]/dots);

            o.pixData = pixData;
            o.x = x+dotSize/2;
            o.y = imgH-y-dotSize/2;
            o.size = dotSize/2*0.95;
            circlesData.push(o);
		}
	}	
	self.postMessage(circlesData);
});
