window.addEventListener('DOMContentLoaded', function(evt) {

    document.addEventListener('tizenhwkey', function(evt) {
        if(evt.keyName === 'back') {
            tizen.application.getCurrentApplication().exit();        	
        }
    });	
	
	var cnvs = document.getElementById('image-view'),
		info = document.getElementById('info-busy'),
		alist = document.querySelectorAll('#file-list a'),
		fileSelector = document.getElementById('file-selector'),
		ctx = cnvs.getContext('2d'),
		worker;
	
	cnvs.addEventListener('touchstart', function(evt){
		applyEffect();
	});
	
	function listClickHandler(evt) {
		evt.preventDefault();
		ctx.clearRect(0, 0, cnvs.width, cnvs.height);		
		stopWorker();
		loadImage(this.getAttribute('href'));
	}
	
	for(var i=0; i<alist.length;++i) {
		alist[i].addEventListener('touchstart', listClickHandler);
	}
	
	fileSelector.addEventListener('change', function(evt) {
		ctx.clearRect(0, 0, cnvs.width, cnvs.height);		
		stopWorker();		
		loadFile(this.files[0]);
		this.value = '';
	});
	
	function loadFile(file) {		
		ctx.clearRect(0, 0, cnvs.width, cnvs.height);		
		var reader = new FileReader();
		reader.addEventListener('load', function(evt) {
			loadImage(reader.result);
		});
		reader.addEventListener('error', errorHandler);
		reader.readAsDataURL(file);
	}
	
	function loadImage(src) {
		var img = new Image();
		img.addEventListener('load', function(evt){			
			cnvs.width = this.naturalWidth;
			cnvs.height = this.naturalHeight;
			/*
			 *	resize canvas to fit view area 
			 */	
			var kw = this.naturalWidth / (window.innerWidth*0.9);
			var kh = this.naturalHeight / (window.innerHeight*0.7);
            var k = Math.max(kw,kh);
			cnvs.style.width = Math.floor(this.naturalWidth / k) + 'px';
			cnvs.style.height = Math.floor(this.naturalHeight / k) + 'px';
			
			ctx.drawImage(this, 0, 0);
		});
		img.src = src;		
	}

	function applyEffect() {
		stopWorker();
		worker = new Worker('js/worker.js');
		worker.addEventListener('message',function(evt){
            ctx.fillStyle = 'rgba(0,0,0,255)';
            ctx.fillRect(0,0,cnvs.width,cnvs.height);
			for(var i=0, o, circlesData = evt.data; i<circlesData.length ;++i) {
				var o = circlesData[i];
				ctx.fillStyle = 'rgba('+ o.pixData[0]+','+o.pixData[1]+','+o.pixData[2]+',255)';
				ctx.beginPath();
				ctx.arc(o.x, o.y, o.size, 0, 2*Math.PI, false);
				ctx.closePath();
				ctx.fill();				
			}
			stopWorker();
			info.style.visibility = 'hidden';
		});
		
		info.style.visibility = 'visible';
		worker.postMessage({
			imgW: cnvs.width,
			imgH: cnvs.height,
            orginalData: ctx.getImageData(0, 0, cnvs.width, cnvs.height),
			dotSize: 6,
			dotSize2: 36
		});
	}
	
	function stopWorker() {
		if(worker) {
			worker.terminate();
			worker = null;
		}
	}
	
	document.getElementById('save-btn').addEventListener('touchstart', function(evt){
		var fileName = 'circle-pixel-effect.png',
			f;
		try {
			tizen.filesystem.resolve('images', function(dir){
				try {
					f = dir.resolve(fileName);
				} catch(err) {
					console.log(err);
				}
				try {
					if(!f) f = dir.createFile(fileName);
				} catch(err) {
					console.log(err);
				}
				
				if(f) {
					f.openStream('w', function(fs) {
						try {
							fs.writeBase64(cnvs.toDataURL('image/png', 0.8).replace('data:image/png;base64,', '') );
							fs.close();						
						} catch(err) {
							console.log(err);
						}
					}, errorHandler);					
				}
			}, errorHandler, 'w');			
		} catch(err) {
			console.log(err);
			window.open(cnvs.toDataURL('image/jpeg', 0.8),'');
		}
	});
	
	function errorHandler(err) {
		console.log(err);
	}	
});