rotaryDetentCallback = function rotaryDetentHandler(e) {
	domagic();
};
window.addEventListener("rotarydetent", rotaryDetentCallback);

var randomScalingFactor = function() {
    return Math.round(Math.random() * 100);
};
var randomColorFactor = function() {
    return Math.round(Math.random() * 255);
};
var randomColor = function(opacity) {
    return 'rgba(' + randomColorFactor() + ',' + randomColorFactor() + ',' + randomColorFactor() + ',' + (opacity || '.3') + ')';
};

var config = {
    type: 'pie',
    data: {
        datasets: [{
            data: [
                randomScalingFactor(),
                randomScalingFactor(),
                randomScalingFactor()
            ],
            backgroundColor: [
                randomColor(),
                randomColor(),
                randomColor()
            ],
            label: 'Dataset 1'
        }, {
        	// Add if you need
            hidden: true,
            data: [
                randomScalingFactor(),
                randomScalingFactor(),
                randomScalingFactor()
            ],
            backgroundColor: [
                "#F7464A",
                "#46BFBD",
                "#FDB45C"
            ],
            label: 'Dataset 2'
        }],
        labels: [
            "One",
            "Two",
            "Three"
        ]
    },
    options: {
        responsive: true,
        legend: {
            position: "top",
        },
        title: {
            display: true,
            text: "Hello World"
        }
    }
};

window.onload = function() {
    var ctx = document.getElementById("mychart").getContext("2d");
    window.myDoughnut = new Chart(ctx, config);
};

function domagic()
{
	$.each(config.data.datasets, function(i, dataset) {
        dataset.data = dataset.data.map(function() {
            return randomScalingFactor();
        });

        dataset.backgroundColor = dataset.backgroundColor.map(function() {
            return randomColor(0.7);
        });
    });

    window.myDoughnut.update();
}