document.addEventListener('DOMContentLoaded', function(evt){
	
	document.addEventListener('tizenhwkey', function(evt) {
		if(evt.keyName === 'back') {
			try {
				tizen.application.getCurrentApplication().exit();
			} catch (err) {
				console.error("getCurrentApplication(): " + err.message);
			}
		}
	});	
	
	var parameters = [	{color:'#fff305',shape:'spiral',density:160,range:0.7,speed:6,fps:30},
	                  	{color:'#00fff2',shape:'oval',density:160,range:0.8,speed:4,fps:30},
		              	{color:'#cddedd',shape:'oval',density:13,range:0.5,speed:1,fps:30},	
		            	{color:'#ff85ff',shape:'rect',density:140,range:.8,speed:10,fps:30},
		            	{color:'#a2ff99',shape:'rect',density:15,range:1,speed:1,fps:30},
		            	{color:'#ff7700',shape:'roundRect',density:10,range:0.7,speed:1,fps:30} ];
	var diameter = Math.round(Math.min(screen.width,screen.height)/5*0.7);	
	
	parameters.forEach(function(el,i){
		var cl = new CanvasLoader('loader-con-'+(i+1),{id:'loader-'+(i+1)});
		cl.setColor(el.color);
		cl.setShape(el.shape);
		cl.setDiameter(diameter);
		cl.setDensity(el.density);
		cl.setRange(el.range);
		cl.setSpeed(el.speed);
		cl.setFPS(el.fps);	
		cl.isVisible = false;
		document.getElementById('loader-con-'+(i+1)).addEventListener('click',function(evt){
			if(cl.isVisible) {
				cl.isVisible = false;
				cl.hide();
			} else {
				cl.isVisible = true;
				cl.show();
			}
		});		
	});
	
	document.getElementById('loader-con-'+Math.ceil(Math.random()*6)).click();	
});
