/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;

using Xamarin.Forms;

namespace CalculatorUI
{
    /// <summary>
    /// Main page of CalculatorUI app
    /// It is the UI part.
    /// This app layout UI mainly by using Grid.
    /// </summary>
    public partial class CalculatorPage
    {
        /// <summary>
        /// Create UI components.
        /// </summary>
        void InitializeComponent()
        {

            //create main container
            _mainGrid = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            Content = _mainGrid;

            //create Cal's screen part
            _screen = new Entry()
            {
                IsEnabled = false,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                FontSize = 50,
            };

            //create panel which contain Cal's keyPad
            _panel = CreatePanel();

            //add _sreen in the top of _mainGrid
            _mainGrid.Children.Add(
                _screen, 5, 95, 5, 30);

            //add _panel at the bottom of _mainGrid
            _mainGrid.Children.Add(
                _panel, 0, 100, 35, 100);
        }

        /// <summary>
        /// Click Call back of buttons
        /// </summary>
        /// <param name="sender">sender object</param>
        /// <param name="e">event</param>
        private void CharClicked(object sender, EventArgs e)
        {
            Button en = sender as Button;
            //append new Character
            if (_screen.Text.Length < 20)
            {
                _screen.Text += en.Text;
            }
        }

        /// <summary>
        /// Create basic calculator pad
        /// </summary>
        /// <returns>return Grid layout</returns>
        private Grid CreateBasicPad()
        {
            //Grid layout
            Grid basisPadGrid = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                ColumnSpacing = 10,
                RowSpacing = 10,
            };

            //Add buttons to Grid
            Button btn = new Button()
            {
                Text = "C",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += (sender, e) =>
            {
                //"C" button, clear all text.
                _screen.Text = "";
            };
            basisPadGrid.Children.Add(btn, 0, 1, 0, 1);

            btn = new Button()
            {
                Text = "/",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 1, 2, 0, 1);

            btn = new Button()
            {
                Text = "X",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 2, 3, 0, 1);

            btn = new Button()
            {
                Text = "Back",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += (sender, e) =>
            {
                //"Back" button, remove last char
                string text = _screen.Text;
                if (text.Length > 0)
                {
                    _screen.Text = text.Substring(0,text.Length - 1);
                }
            };
            basisPadGrid.Children.Add(btn, 3, 4, 0, 1);

            btn = new Button()
            {
                Text = "7",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 0, 1, 1, 2);

            btn = new Button()
            {
                Text = "8",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 1, 2, 1, 2);

            btn = new Button()
            {
                Text = "9",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 2, 3, 1, 2);

            btn = new Button()
            {
                Text = "-",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 3, 4, 1, 2);

            btn = new Button()
            {
                Text = "4",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 0, 1, 2, 3);

            btn = new Button()
            {
                Text = "5",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 1, 2, 2, 3);

            btn = new Button()
            {
                Text = "6",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 2, 3, 2, 3);

            btn = new Button()
            {
                Text = "+",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 3, 4, 2, 3);

            btn = new Button()
            {
                Text = "1",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 0, 1, 3, 4);

            btn = new Button()
            {
                Text = "2",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 1, 2, 3, 4);

            btn = new Button()
            {
                Text = "3",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 2, 3, 3, 4);

            btn = new Button()
            {
                Text = "( )",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 3, 4, 3, 4);

            btn = new Button()
            {
                Text = "0",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 0, 1, 4, 5);

            btn = new Button()
            {
                Text = ".",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 1, 2, 4, 5);

            btn = new Button()
            {
                Text = "+/-",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 2, 3, 4, 5);

            btn = new Button()
            {
                Text = "=",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            basisPadGrid.Children.Add(btn, 3, 4, 4, 5);

            return basisPadGrid;
        }

        /// <summary>
        /// Create advance calculator pad
        /// </summary>
        /// <returns>return Grid layout</returns>
        private Grid CreateAdvancePad()
        {
            //Grid layout
            Grid adPadGrid = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                ColumnSpacing = 10,
                RowSpacing = 10,
            };

            //add buttons to Grid
            Button btn = new Button()
            {
                Text = "x!",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 0, 1, 0, 1);

            btn = new Button()
            {
                Text = "sqrt",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 1, 2, 0, 1);

            btn = new Button()
            {
                Text = "%",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 2, 3, 0, 1);

            btn = new Button()
            {
                Text = "sin",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 0, 1, 1, 2);

            btn = new Button()
            {
                Text = "cos",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 1, 2, 1, 2);

            btn = new Button()
            {
                Text = "tan",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 2, 3, 1, 2);

            btn = new Button()
            {
                Text = "ln",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 0, 1, 2, 3);

            btn = new Button()
            {
                Text = "log",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 1, 2, 2, 3);

            btn = new Button()
            {
                Text = "1/x",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 2, 3, 2, 3);

            btn = new Button()
            {
                Text = "e^x",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 0, 1, 3, 4);

            btn = new Button()
            {
                Text = "X^2",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 1, 2, 3, 4);

            btn = new Button()
            {
                Text = "Y^x",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 2, 3, 3, 4);

            btn = new Button()
            {
                Text = "|x|",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 0, 1, 4, 5);

            btn = new Button()
            {
                Text = "PI",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 1, 2, 4, 5);

            btn = new Button()
            {
                Text = "e",
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };
            btn.Clicked += CharClicked;
            adPadGrid.Children.Add(btn, 2, 3, 4, 5);

            return adPadGrid;
        }

        /// <summary>
        /// Calculator panel, contain calculator pad.
        /// </summary>
        /// <returns>Return Grid layout</returns>
        private View CreatePanel()
        {
            //Create Grid layout
            Grid grid = new Grid()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
            };

            _basicPad = CreateBasicPad();
            if (_isLandScape == false)
            {
                //Portrait, only display basicPad
                grid.Children.Add(_basicPad, 0, 97, 3, 97);
            }
            else
            {
                //Landscape, layout advance pad on left, basic pad on right.
                _advancePad = CreateAdvancePad();
                grid.Children.Add(_advancePad, 0, 42, 0, 1);
                grid.Children.Add(_basicPad, 45, 97, 0, 1);
            }

            _panelGrid = grid;

            //use stacklayout instead of Panel now
            StackLayout panel = new StackLayout()
            {
                IsVisible = true,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                Orientation = StackOrientation.Vertical,
                Padding = new Thickness(10),
                Children = {grid}
            };

            return panel;
        }
    }
}

