/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;

namespace CalculatorUI
{
    /// <summary>
    /// Main page of CalculatorUI app
    /// It is the logic part
    /// </summary>
    public partial class CalculatorPage : ContentPage
    {
        private Grid _mainGrid;
        private Entry _screen;
        private View _panel;
        private Grid _panelGrid;
        private Grid _basicPad = null;
        private bool _isLandScape = false;
        private Grid _advancePad = null;

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="isLandScape">is landscape or not</param>
        public CalculatorPage(bool isLandScape)
        {
            _isLandScape = isLandScape;
            InitializeComponent();
        }

    }

}
