﻿using Calculator.Impl;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using Xamarin.Forms;

namespace Calculator.Controls
{
    /// <summary>
    /// A element button which is implemented with a custom renderer based on a native image. </summary>
    public partial class ElementButton : Image
    {
        /// <summary>
        /// A color when the button is pressed. </summary>
        public Color BlendingPressedColor
        {
            get;
            set;
        }

        public static readonly BindableProperty CommandProperty =
           BindableProperty.Create(nameof(Command), typeof(ICommand), typeof(ElementButton), null, BindingMode.TwoWay);

        /// <summary>
        /// A command will be executed if the button is touched. </summary>
        public ICommand Command
        {
            get { return (ICommand)GetValue(CommandProperty); }
            set { SetValue(CommandProperty, value); }
        }

        /// <summary>
        /// A command parameter will be passed when the Command is executed. </summary>
        /// <see cref="CommandButton.Command"/>
        public String CommandParameter
        {
            get;
            set;
        }

        public ElementButton()
        {
            BlendingPressedColor = Color.White;
            BackgroundColor = Color.Transparent;
            CommandParameter = "";

            InitializeComponent();
        }
    }
}
