﻿using System;
using System.Windows.Input;
using Xamarin.Forms;

namespace Calculator.Controls
{
    /// <summary>
    /// A command button which is implemented with a custom renderer based on a native image. </summary>
    public partial class CommandButton : Image
    {
        public static readonly BindableProperty CommandProperty =
           BindableProperty.Create(nameof(Command), typeof(ICommand), typeof(CommandButton), null, BindingMode.TwoWay);

        /// <summary>
        /// A command will be executed if the button is touched. </summary>
        public ICommand Command
        {
            get { return (ICommand)GetValue(CommandProperty); }
            set { SetValue(CommandProperty, value); }
        }

        /// <summary>
        /// A command parameter will be passed when the Command is executed. </summary>
        /// <see cref="CommandButton.Command"/>
        public String CommandParameter
        {
            get;
            set;
        }

        public CommandButton()
        {
            CommandParameter = "";
            InitializeComponent();
        }
    }
}
