﻿using UnityEngine;
using System.Collections;
using Tizen.AdLib;
using System;

public class AdListener:InterstitialAdListener
{
	public void OnAdClosed (IntPtr handle)
	{
	}
	
	public void OnAdLoadFailed (IntPtr handle, ErrorType error)
	{
	}
	
	public void OnAdLoadSucceeded (IntPtr handle)
	{
		Debug.Log ("Entered in to OnAdLoadSucceeded");
		AdProvider.Instance.InterstitialAdShow ();
	}
	
	public void OnAdOpened (IntPtr handle)
	{
	}
}

public class Paddle : MonoBehaviour {
	public float paddleSpeed = 1f;
	private Vector3 playerPos = new Vector3 (0f, -9.63f, 0f);
	AdProvider adobject = AdProvider.Instance;

	void Start () {
		IntPtr handle, handle2;
		adobject.InitAdlib ("6eb8367d91c74369acca148f3441fe52");
		Debug.Log ("Entered in to start");

		adobject.AddInterstitialAd ();
		adobject.InterstitialAdLoad ();

		ErrorType result = adobject.AddBannerAd (BannerAdSize.BANNER_AD_SIZE_BIG, out handle);
		Debug.Log ("Handle value:"+handle);
		adobject.BannerAdLoad (handle);

		result = adobject.AddBannerAd (BannerAdSize.BANNER_AD_SIZE_SMALL, out handle2);
		Debug.Log ("Handle value:"+handle2);
		adobject.BannerAdLoad (handle2);
		adobject.BannerAdSetPosition (handle2, BannerAdPosition.BANNER_AD_POS_TOP_CENTER);


	}
	// Update is called once per frame
	void Update () {
		float xPos = transform.position.x + (Input.GetAxis ("Horizontal") * paddleSpeed);
		playerPos = new Vector3 (Mathf.Clamp (xPos, -8f, 8f), -9.63f, 0f);
		transform.position = playerPos;
	}
}

