document.addEventListener('tizenhwkey', function (e) {
  if (e.keyName === 'back') {
    tizen.application.getCurrentApplication().exit();
  }
});

var show = new Blaze.Var(true);

var scale = new Blaze.Var(1);
var roundness = new Blaze.Var(50);

var position = {
  x: new Blaze.Var(100),
  y: new Blaze.Var(100)
};

var setPosition = function (p, v) {
  position[p].set(Math.max(0, Math.min(290, position[p].get() + v)));
};

Template.main.events({
  'touchstart .arrow': function (e, tmpl) {
    var arrow = e.currentTarget;
    var direction = arrow.classList.item(2);
    
    if (!show.get()) return;

    switch (direction) {
    case 'up':
      setPosition('y', -10);
      break;
    case 'right':
      setPosition('x', +10);
      break;
    case 'down':
      setPosition('y', +10);
      break;
    case 'left':
      setPosition('x', -10);
      break;
    }
  },
  'touchend .toggle': function () {
    show.set(!show.get());
  },
  'input .scale': function (e) {
    var range = e.currentTarget;
    scale.set(range.value);
  },
  'input .roundness': function (e) {
    var range = e.currentTarget;
    roundness.set(range.value);
  }
});

Template.main.helpers({
  x: function () {
    return position.x.get();
  },
  y: function () {
    return position.y.get();
  },
  show: function () {
    return show.get();
  },
  active: function () {
    return show.get() ? 'active' : '';
  },
  scale: function () {
    return scale.get();
  },
  roundness: function () {
    return roundness.get();
  }
});