var BG_COLOR = 0x0d1b3c;

var mycanvas, renderer, stage;
var stageWidth, stageHeight;

var stats;

var assetsToLoad;

var tentacleclip, roverclip;

var tentacleFrames = [];
var roverFrames = [];

//Initialize function
var init = function () {
	
	////////////  GAME INITIALISATION  /////////////		   
	 
	// Before loading the JSON into your project please use http://jsbeautifier.org/ to enhance it
	   assetsToLoad = ["images/BasketGame.json"];
	
	// CREATE A NEW ASSET LOADER
	   loader = new PIXI.AssetLoader(assetsToLoad);
	// USE CALLBACK
	   loader.onComplete = onAssetsLoaded.bind(this);
	// BEGIN LOADING THE ASSETS
	   loader.load();

	function onAssetsLoaded() { 
		
		console.log("ASSETS LOADED!");
			
		// FETCH THE CANVAS ELEMENT 
		   mycanvas = document.getElementById("myCanvas");
	 
		// SET THE STAGE WIDTH AND HEIGHT
		// stageWidth = window.innerWidth;
	    // stageHeight = window.innerHeight;	 

		   stageWidth = 720;
		   stageHeight = 1280;
		 
		// CREATE A NEW PIXI.JS STAGE AND SET THE AUTOMATIC RENDERER DETECTION
		   stage = new PIXI.Stage(BG_COLOR, true); // <-- second parameter 'true' sets the stage interactivity
		   renderer = PIXI.autoDetectRenderer(stageWidth, stageHeight);
		 
		   document.body.appendChild(renderer.view);
		   
		   /////////////// STATS.JS /////////////////
		   
		       stats = new Stats();
		       
			   stats.setMode(0);
			   stats.domElement.style.position = 'absolute';
			   stats.domElement.style.left = '0px';
			   stats.domElement.style.top = '0px';
			   
			   document.body.appendChild( stats.domElement );
		
		   //////////////////////////////////////////	   
			   
			  function zeroPad(num, places) { // THE ZERO PADDING FUNCTION FOR THE JSON FRAME NAMES
				 var zero = places - num.toString().length + 1;
				 return Array(+(zero > 0 && zero)).join("0") + num;
			  }

		   /*** YOU CAN GENERATE THE MOVIECLIP FRAME NAMES WITH JSON NAMES USING THE FOR LOOPS WHICH IS MORE CONVIENIENT... ***/
			  
			  for (var fr = 0; fr < 18; fr++) { // GENERATE 18 FRAME NAMES FOR THE TENTACLE LIKE IN THE JSON
			  
				 var tentFrameName = String("tentacle" + zeroPad(fr,4));
				 	 tentacleFrames.push(tentFrameName);
				  
			  }	  
			  
			  for (var r = 0; r < 12; r++) { // GENERATE 12 FRAME NAMES FOR THE ROVER (SIDEMONSTER) LIKE IN THE JSON
				  
					 var roverFrameName = String("sideMonster" + zeroPad(r,4));
					 	 roverFrames.push(roverFrameName);
					  
			  }	  
			 
		   /*** ... OR YOU CAN ALWAYS USE A STANDARD ARRAY WITH WRITTEN BY HAND FRAME NAMES FROM THE JSON LIKE BELOW INSTEAD ***
			   
			   var tentacleFrames = ["tentacle0000","tentacle0001","tentacle0002","tentacle0003","tentacle0004",
			                 		 "tentacle0005","tentacle0006","tentacle0007","tentacle0008","tentacle0009",
			                 		 "tentacle0010","tentacle0011","tentacle0012","tentacle0013","tentacle0014",
			                 		 "tentacle0015","tentacle0016","tentacle0017"];
			                 		 
			   var roverFrames = ["sideMonster0000","sideMonster0001","sideMonster0002",
			                 	  "sideMonster0003","sideMonster0004","sideMonster0005",
			                 	  "sideMonster0006","sideMonster0007","sideMonster0008",
			                 	  "sideMonster0009","sideMonster0010","sideMonster0011"];
			                 		 
		    */
			
			// TENTACLE MOVIECLIP
			   tentacleclip = new PIXI.MovieClip.fromFrames(tentacleFrames);
			   tentacleclip.animationSpeed = 0.5;
			   tentacleclip.play();
			 
			// POSITION THE TENTACLE
			   tentacleclip.position.x = stageWidth/2 - tentacleclip.width/2;
			   tentacleclip.position.y = 1000;
			   
			   		stage.addChild(tentacleclip);
			   		
			// ROVER MOVIECLIP   
			   roverclip = new PIXI.MovieClip.fromFrames(roverFrames);
			   roverclip.animationSpeed = 0.5;
			   roverclip.play();
			   
			// POSITION THE ROVER
			   roverclip.position.x = 550;
			   roverclip.position.y = 500;
			   
			   		stage.addChild(roverclip);
			
			   
			   function draw() {  
				  
				  stats.begin();
				  
				  // MOVE THE TENTACLE
				  	  tentacleclip.position.x += 3;
								  
				  // MOVE THE ROVER
					  roverclip.position.x -= 5;
					  
				  // IF THE ROVER GOES OUT FROM THE SCREEN THROUGH THE LEFT SCREEN EDGE POSITION THE ROVER ON THE RIGHT EDGE	  
					  if (roverclip.position.x < -roverclip.width) roverclip.position.x = stageWidth;
					  
				  // IF THE TENTACLE GOES OUT FROM THE SCREEN THROUGH THE RIGHT SCREEN EDGE POSITION THE TENTACLE ON THE LEFT EDGE	  
					  if (tentacleclip.position.x > stageWidth) tentacleclip.position.x = -tentacleclip.width;

					  		renderer.render(stage); 
				      		requestAnimationFrame(draw);
			        
				  stats.end();
			   }
			   
			   draw();
		
	}
	
	

	// add eventListener for tizenhwkey
	document.addEventListener('tizenhwkey', function(e) {
		if(e.keyName == "back") {
			try {
				tizen.application.getCurrentApplication().exit();
			} catch (error) {
				console.error("getCurrentApplication(): " + error.message);
			}
		}
	});
};
// window.onload can work without <body onload="">
window.onload = init;
