// set variables
var counter;

var add;
var decrease;
var reset;
var automatic;

var appId;
var badgeCount;

var autoFlag = false;
var autoCount;

//Initialize function
var init = function () {
		console.log("init() called");

	 // get the current Tizen app ID
	    appId = tizen.application.getCurrentApplication().appInfo.id;
	
     // register HTML elements as variables in JavaScript
		counter = document.getElementById("counter");
		add = document.getElementById("add-btn");
		decrease = document.getElementById("decrease-btn");
		reset = document.getElementById("reset-btn");
		automatic = document.getElementById("auto-btn");
		
	 // show the stored badge count
		showBadgeCount();
		
	 // register listeners for buttons manipulating the badge count
	    add.addEventListener('touchstart', addBadgeCount, false);
	    decrease.addEventListener('touchstart', decreaseBadgeCount, false);
	    reset.addEventListener('touchstart', resetBadgeCount, false);
	    automatic.addEventListener('touchstart', autoBadgeCount, false);
			
	function addBadgeCount() { // the badge add count method
		badgeCount = tizen.badge.getBadgeCount(appId);
		badgeCount++;
		tizen.badge.setBadgeCount(appId, badgeCount);
		showBadgeCount();
	}	
	
	function decreaseBadgeCount() { // the badge count decrease method
		badgeCount = tizen.badge.getBadgeCount(appId);
		if (badgeCount > 0) badgeCount--;
		tizen.badge.setBadgeCount(appId, badgeCount);
		showBadgeCount();
	}
	
	function autoBadgeCount() { // toggle auto counting (on / off)
		if (autoFlag == true) {
			clearInterval(autoCount);
			autoFlag = false;
			automatic.innerHTML = "Automatic badge count add (START)";
		}
		else
		{
			autoCount = setInterval(selfCount, 1000);
			autoFlag = true;
			automatic.innerHTML = "Automatic badge count add (STOP)";
		}
	}
	
	function selfCount() { // automatic adding of the badge count
		addBadgeCount();
	}
	
	function resetBadgeCount() { // reset the badge count
		tizen.badge.setBadgeCount(appId, 0);  
		showBadgeCount();
	}
	
	function showBadgeCount() {	// display the badge count in the counter <div>
			badgeCount = tizen.badge.getBadgeCount(appId);
			counter.innerHTML = "You have " + badgeCount + " badges in your app";
	}	
		
	// add eventListener for tizenhwkey
	document.addEventListener('tizenhwkey', function(e) {
		if(e.keyName == "back") {
			try {
				tizen.application.getCurrentApplication().exit();
			} catch (error) {
				console.error("getCurrentApplication(): " + error.message);
			}
		}
	});
};
// window.onload can work without <body onload="">
window.onload = init;

