 //Capability testing & Getting default sensor
 var lightCapability = tizen.systeminfo.getCapability("http://tizen.org/feature/sensor.photometer");
 if (lightCapability === true) {
	 var lightSensor = tizen.sensorservice.getDefaultSensor("LIGHT");
 }
 
 var sc=0;
 
 function startSens(){
	 //read sensor data
	 function onGetSuccessCB(sensorData) {
		 document.getElementById("light-result").innerHTML="Light Sensor data: " +sensorData.lightLevel+" lux";
		 
		 //UI change depending on current light level
		 if(parseInt(sensorData.lightLevel)>500){
	    	 var on="url(\'/" + "../images/on.png" + "\')";
	    	 document.body.style.backgroundImage = on;
	     }
	     else{
	    	 var off="url(\'/" + "../images/off.png" + "\')";
	    	 document.body.style.backgroundImage = off;
	     }
		 
		 // determining Ideal brightness based on justified data
		 var val=parseInt(sensorData.lightLevel);

		 switch (true) {
		 	case (val < 9):	 		
		        sc=.35;
		        break;
		    case (val >= 9 && val <= 38):
		    	sc=.42;
	        	break;
		    case (val >= 38 && val <= 65):
		    	sc=.53;
	        	break;
		    case (val >= 65 && val <= 146):
		    	sc=.71;
	        	break;
		    case (val >= 146 && val <= 296):
		    	sc=.76;
	        	break;
		    case (val >= 296 && val <= 545):
		    	sc=.85;
	        	break;
		    case (val >= 545 && val <= 924):
		    	sc=.93;
	        	break;
	        case (val >= 924 && val <= 1254):
		    	sc=.98;
        		break;
	        case (val >= 1254):
	        	sc=1;
        		break;	
		 }
		 
		 document.getElementById("IdealBrightness").innerHTML = "IdealBrightness: " + sc;
		 getBright();
		 console.log("light level : " + sensorData.lightLevel);
		 
		 if(auto==true){
			 setBright();
		 }
	 }

	 function onerrorCB(error) {
	     console.log("error occurs");
	 }
	 
	 function onsuccessCB() {
	     console.log("sensor start");
	     lightSensor.getLightSensorData(onGetSuccessCB, onerrorCB);
	 }
	 	
	 if(lightCapability==false)
		 document.getElementById("light-result").innerHTML="Device not Supported";
	 else{
		 lightSensor.setChangeListener(onsuccessCB);
		 lightSensor.start(onsuccessCB);
	 }
 }
 
 //Stop Light Sensor
 function stopSens(){
	 lightSensor.stop();
 }
