document.addEventListener('tizenhwkey', function(e) {
  if (e.keyName == 'back') {
    try {
      if (template.get() !== 'Members') {
        template.set('Members');
      } else {
        tizen.application.getCurrentApplication().exit();
      }
    } catch (error) {
      console.error('getCurrentApplication(): ' + error.message);
    }
  }
});

Members = new Mongo.Collection('members');

Member = Astro.Class({
  name: 'Member',
  collection: Members,
  fields: {
    firstName: 'string',
    lastName: 'string',
    email: 'string',
    age: 'number'
  },
  validators: {
    firstName: Validators.and([
      Validators.str(),
      Validators.minlen(3)
    ]),
    lastName: Validators.and([
      Validators.str(),
      Validators.minlen(3)
    ]),
    email: Validators.and([
      Validators.str(),
      Validators.email(3)
    ]),
    age: Validators.and([
      Validators.num(),
      Validators.gte(18),
      Validators.lte(100)
    ])
  }
});

Template.Members.events({
  'click [name=add]': function(e, tmpl) {
    template.set('Add');
  }
});

Template.Member.events({
  'click .edit': function(e, tmpl) {
    id.set(this._id);
    template.set('Edit');
  },
  'click .remove': function(e, tmpl) {
    this.remove();
    saveDatabase();
  }
});

Template.Form.events({
  'change input': function(e, tmpl) {
    var field = e.currentTarget;
    this[field.id] = field.value;
    this.validate(field.id);
  },
  'click [name=save]': function(e, tmpl) {
    if (this.validate()) {
      this.save();
      saveDatabase();
      template.set('Members');
    }
  }
});

var template = new Blaze.Var('Members');
var id = new Blaze.Var('');

var saveDatabase = function() {
  var data = Members._collection._docs._map;
  localStorage.setItem('database', JSON.stringify(data));
};

var loadDatabase = function() {
  var data = JSON.parse(localStorage.getItem('database'));
  if (data) {
    Members._collection._docs._map = data;
  }
};

Meteor.startup(function() {
  loadDatabase();
});

Template.main.helpers({
  template: function() {
    return template.get();
  }
});

Template.Members.helpers({
  members: function() {
    return Members.find({}, {
      sort: {
        age: -1
      }
    });
  }
});

Template.Edit.helpers({
  member: function() {
    return Members.findOne(id.get());
  }
});

Template.Add.helpers({
  member: function() {
    return new Member();
  }
});

EJSON = Package.ejson.EJSON;
