﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using Xamarin.Forms;

namespace ApplicationLayoutSamples.Pages
{
    /// <summary>
    /// A class for Login page
    /// </summary>
    public class LoginPage : ContentPage
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LoginPage"/> class.
        /// </summary>
        /// <param name="title">title</param>
        public LoginPage(string title)
        {
            // Title for this page.
            Label tt = new Label
            {
                Text = title,
                TextColor = Color.White,
                FontSize = 28,
                HeightRequest = App.ScreenHeight * 0.075,
                HorizontalOptions = LayoutOptions.Center
            };

            // Generate login grid.
            Grid loginGrid = new Grid
            {
                ColumnDefinitions =
                {
                    new ColumnDefinition { Width = App.ScreenWidth * 0.49 },
                    new ColumnDefinition { Width = App.ScreenWidth * 0.49 }
                },
                RowDefinitions =
                {
                    new RowDefinition { Height = App.ScreenHeight * 0.078 },
                    new RowDefinition { Height = App.ScreenHeight * 0.078 },
                    new RowDefinition { Height = App.ScreenHeight * 0.078 }
                },
            };
            loginGrid.Children.Add(CreateLabel("Email Account: "), 0, 0);
            loginGrid.Children.Add(CreateInput(false), 1, 0);
            loginGrid.Children.Add(CreateLabel("Password: "), 0, 1);
            loginGrid.Children.Add(CreateInput(true), 1, 1);
            loginGrid.Children.Add(CreateButton("Cancel"), 0, 2);
            loginGrid.Children.Add(CreateButton("Login"), 1, 2);

            Content = new StackLayout()
            {
                Children =
                {
                    tt,
                    new StackLayout()
                    {
                        Padding = new Thickness(0, App.ScreenHeight * 0.078, 0, 0),
                        HorizontalOptions = LayoutOptions.FillAndExpand,
                        VerticalOptions = LayoutOptions.FillAndExpand,
                        BackgroundColor = Color.White,
                        Children =
                        {
                            loginGrid
                        }
                    }
                }
            };
        }

        /// <summary>
        /// A method to create a new label.
        /// </summary>
        /// <param name="text">The label's text</param>
        /// <returns>Return the new label</returns>
        public Label CreateLabel(string text)
        {
            Label label = new Label
            {
                Text = text,
                HorizontalTextAlignment = TextAlignment.End,
                FontSize = 20
            };

            return label;
        }

        /// <summary>
        /// A method to create a new entry with underline.
        /// </summary>
        /// <param name="isPassword">The entry's style</param>
        /// <returns>Return the new entry layout</returns>
        public StackLayout CreateInput(bool isPassword)
        {
            Entry input = new Entry
            {
                IsPassword = isPassword,
                FontSize = 20,
                Margin = new Thickness(20, 0, 20, 0)
            };
            BoxView underline = new BoxView
            {
                HeightRequest = 1.5,
                BackgroundColor = Color.Blue,
                Margin = new Thickness(20, 10, 20, 20)
            };
            StackLayout inputLayout = new StackLayout
            {
                Children =
                {
                    input,
                    underline
                }
            };

            return inputLayout;
        }

        /// <summary>
        /// A method to create a new button.
        /// </summary>
        /// <param name="text">The button's text</param>
        /// <returns>Return the new button</returns>
        public Button CreateButton(string text)
        {
            Button button = new Button
            {
                Margin = new Thickness(50, 10, 50, 10),
                Text = text,
                FontSize = 20
            };
            if (text == "Cancel")
            {
                button.Clicked += CancelCallBack;
            }
            else
            {
                button.Clicked += LoginCallBack;
            }

            return button;
        }

        private void CancelCallBack(object sender, EventArgs e)
        {
            Navigation.PopModalAsync();
        }

        private void LoginCallBack(object sender, EventArgs e)
        {
            Navigation.PushModalAsync(new NoContentPage("Login Successful!"));
        }
    }
}