﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;
using Xamarin.Forms.Platform.Tizen;
using ApplicationLayoutSamples.Custom;
using ApplicationLayoutSamples.Tizen;

[assembly: ExportRenderer(typeof(CustomFavorite), typeof(CustomFavoriteRenderer))]
namespace ApplicationLayoutSamples.Tizen
{
    /// <summary>
    /// Custom favorite renderer for app.
    /// It inherit from SwitchRenderer.
    /// </summary>
    public class CustomFavoriteRenderer : SwitchRenderer
    {
        /// <summary>
        /// When favorite's element changed
        /// </summary>
        /// <param name="e">Switch</param>
        protected override void OnElementChanged(ElementChangedEventArgs<Switch> e)
        {
            base.OnElementChanged(e);

            if (Control != null)
            {
                Control.Style = "favorite";
            }
        }
    }
}