﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;

namespace ApplicationLayoutSamples.Pages
{
    /// <summary>
    /// A class for Search page
    /// </summary>
    public class SearchPage : ContentPage
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SearchPage"/> class.
        /// </summary>
        /// <param name="title">title</param>
        public SearchPage(string title)
        {
            // Title for this page.
            Label tt = new Label
            {
                Text = title,
                TextColor = Color.White,
                FontSize = 28,
                HeightRequest = App.ScreenHeight * 0.075,
                HorizontalOptions = LayoutOptions.Center
            };
            Content = new StackLayout()
            {
                Children =
                {
                    tt,
                    new StackLayout()
                    {
                        HorizontalOptions = LayoutOptions.FillAndExpand,
                        VerticalOptions = LayoutOptions.FillAndExpand,
                        BackgroundColor = Color.White
                    }
                }
            };
        }
    }
}
