﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;
using System.Collections.Generic;

namespace ApplicationLayoutSamples.Pages
{
    public class MainPage : ContentPage
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="MainPage"/> class.
        /// </summary>
        public MainPage()
        {
            var sourceList = new List<string>();
            sourceList.Add("Editfield");
            sourceList.Add("No Content");
            sourceList.Add("Search Bar");
            sourceList.Add("Login");
            sourceList.Add("Search");
            sourceList.Add("Scroll in Scroll");

            var mainListView = new ListView()
            {
                ItemsSource = sourceList,
            };

            mainListView.ItemTapped += async (s, a) =>
            {
                if (a.Item.ToString() == "Editfield")
                {
                    await Navigation.PushModalAsync(new EditfieldPage(a.Item.ToString()));
                }
                else if (a.Item.ToString() == "No Content")
                {
                    await Navigation.PushModalAsync(new NoContentPage(a.Item.ToString()));
                }
                else if (a.Item.ToString() == "Search Bar")
                {
                    await Navigation.PushModalAsync(new SearchBarPage(a.Item.ToString()));
                }
                else if (a.Item.ToString() == "Login")
                {
                    await Navigation.PushModalAsync(new LoginPage(a.Item.ToString()));
                }
                else if (a.Item.ToString() == "Search")
                {
                    await Navigation.PushModalAsync(new SearchPage(a.Item.ToString()));
                }
                else if (a.Item.ToString() == "Scroll in Scroll")
                {
                    await Navigation.PushModalAsync(new ScrollInScrollPage(a.Item.ToString()));
                }
            };

            // Add a label as view title
            Label title = new Label
            {
                Text = "Application Layout",
                TextColor = Color.White,
                FontSize = 28,
                HeightRequest = App.ScreenHeight * 0.075,
                HorizontalOptions = LayoutOptions.Center
            };

            Content = new StackLayout
            {
                Children =
                {
                    title,
                    mainListView,
                }
            };
        }
    }

    /// <summary>
    /// A class for item
    /// </summary>
    public partial class Item
    {
        public string MainText { get; set; }
        public string SubText { get; set; }
        public Item(string main, string sub)
        {
            MainText = main;
            SubText = sub;
        }
    }
}
